/*
	File:		Sound.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __SOUND__
#define __SOUND__

#ifndef __TYPES__
#include <MacTypes.H>
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

#define soundListRsrc OST_sndSpc

#define kSoundHardwareType OST_sdev

#define twelfthRootTwo 1.05946309434

enum  {
	swMode			= -1,			/*Sound Driver modes*/
	ftMode			= 1,
	ffMode			= 0,
#define	rate44khz	((long)0xAC440000)	/*44100.00000 in fixed-point*/
#define	rate22khz	((long)0x56EE8BA3)	/*22254.54545 in fixed-point*/
#define	rate11khz	((long)0x2B7745D1)	/*11127.27273 in fixed-point*/
/*synthesizer numbers for SndNewChannel*/
	squareWaveSynth			= 1,			/*square wave synthesizer*/
	waveTableSynth			= 3,			/*wave table synthesizer*/
	sampledSynth			= 5,			/*sampled sound synthesizer*/
/*old Sound Manager MACE synthesizer numbers*/
	MACE3snthID			= 11,
	MACE6snthID			= 13,
	kMiddleC			= 60,			/*MIDI note value for middle C*/
#if !WINVER	// Testing...
	kSimpleBeepID			= 1,			/*reserved resource ID for Simple Beep*/
#define	kFullVolume	0x0100			/*1.0, setting for full hardware output volume*/
	kNoVolume  	      		= 0,			/*setting for no sound volume*/
#endif
/*command numbers for SndDoCommand and SndDoImmediate*/
	nullCmd			= 0,
	initCmd			= 1,
	freeCmd			= 2,
	quietCmd			= 3,
	flushCmd			= 4,
	reInitCmd			= 5,
	waitCmd			= 10,
	pauseCmd			= 11,
	resumeCmd			= 12,
	callBackCmd			= 13
};

enum  {
	syncCmd			= 14,
	availableCmd			= 24,
	versionCmd			= 25,
	totalLoadCmd			= 26,
	loadCmd			= 27,
	freqDurationCmd			= 40,
	restCmd			= 41,
	freqCmd			= 42,
	ampCmd			= 43,
	timbreCmd			= 44,
	getAmpCmd			= 45,
	volumeCmd			= 46,			/*sound manager 3.0 or later only*/
	getVolumeCmd			= 47,			/*sound manager 3.0 or later only*/
	waveTableCmd			= 60,
	phaseCmd			= 61
};

enum  {
	soundCmd			= 80,
	bufferCmd			= 81,
	rateCmd			= 82,
	continueCmd			= 83,
	doubleBufferCmd			= 84,
	getRateCmd			= 85,
	sizeCmd			= 90,
	convertCmd			= 91,
	stdQLength			= 128,
#define dataOffsetFlag	0x8000
/*channel initialization parameters*/
	waveInitChannelMask			= 0x07,
	waveInitChannel0			= 0x04,			/*wave table only, Sound Manager 2.0 and earlier*/
	waveInitChannel1			= 0x05,			/*wave table only, Sound Manager 2.0 and earlier*/
	waveInitChannel2			= 0x06,			/*wave table only, Sound Manager 2.0 and earlier*/
	waveInitChannel3			= 0x07,			/*wave table only, Sound Manager 2.0 and earlier*/
	initChan0			= waveInitChannel0,			/*obsolete spelling*/
	initChan1			= waveInitChannel1,			/*obsolete spelling*/
	initChan2			= waveInitChannel2,			/*obsolete spelling*/
	initChan3			= waveInitChannel3,			/*obsolete spelling*/
	initPanMask			= 0x0003,			/*mask for right/left pan values*/
	initSRateMask			= 0x0030,			/*mask for sample rate values*/
	initStereoMask			= 0x00C0,			/*mask for mono/stereo values*/
	initCompMask			= 0xFF00			/*mask for compression IDs*/
};

enum  {
	initChanLeft			= 0x0002,			/*left stereo channel*/
	initChanRight			= 0x0003,			/*right stereo channel*/
	initNoInterp			= 0x0004,			/*no linear interpolation*/
	initNoDrop			= 0x0008,			/*no drop-sample conversion*/
	initMono			= 0x0080,			/*monophonic channel*/
	initStereo			= 0x00C0,			/*stereo channel*/
	initMACE3			= 0x0300,			/*MACE 3:1*/
	initMACE6			= 0x0400,			/*MACE 6:1*/
	kUseOptionalOutputDevice	= -1,			/*only for Sound Manager 3.0 or later*/
	stdSH			= 0x00,			/*Standard sound header encode value*/
	extSH			= 0xFF,			/*Extended sound header encode value*/
	cmpSH			= 0xFE,			/*Compressed sound header encode value*/
	notCompressed			= 0,			/*compression ID's*/
	fixedCompression			= -1,			/*compression ID for fixed-sized compression*/
	variableCompression			= -2,			/*compression ID for variable-sized compression*/
	twoToOne			= 1,
	eightToThree			= 2,
	threeToOne			= 3,
	sixToOne			= 4,
	outsideCmpSH			= 0			/*MACE constants*/
};

enum  {
	insideCmpSH			= 1,
	aceSuccess			= 0,
	aceMemFull			= 1,
	aceNilBlock			= 2,
	aceBadComp			= 3,
	aceBadEncode			= 4,
	aceBadDest			= 5,
	aceBadCmd			= 6,
	sixToOnePacketSize			= 8,
	threeToOnePacketSize		= 16,
	stateBlockSize			= 64,
	leftOverBlockSize			= 32,
	firstSoundFormat			= 0x0001,			/*general sound format*/
	secondSoundFormat			= 0x0002,			/*special sampled sound format (HyperCard)*/
	dbBufferReady			= 0x0001,			/*double buffer is filled*/
	dbLastBuffer			= 0x0004,			/*last double buffer to play*/
	sysBeepDisable			= 0x0000,			/*SysBeep() enable flags*/
	sysBeepEnable			= 0x0001,
#define unitTypeNoSelection	0xFFFF			/*unitTypes for AudioSelection.unitType*/
	unitTypeSeconds			= 0x0000
};


/*Structures for Sound Driver*/

typedef unsigned char FreeWave[30001];

struct FFSynthRec {
	short			mode;
	Fixed			count;
	FreeWave			waveBytes;
};
typedef struct FFSynthRec FFSynthRec;

typedef FFSynthRec *FFSynthPtr;

struct Tone {
	short			count;
	short			amplitude;
	short			duration;
};
typedef struct Tone Tone;

typedef Tone Tones[5001];

struct SWSynthRec {
	short			mode;
	Tones			triplets;
};
typedef struct SWSynthRec SWSynthRec;

typedef SWSynthRec *SWSynthPtr;

typedef unsigned char Wave[256];

typedef Wave *WavePtr;

struct FTSoundRec {
	short			duration;
	Fixed			sound1Rate;
	long			sound1Phase;
	Fixed			sound2Rate;
	long			sound2Phase;
	Fixed			sound3Rate;
	long			sound3Phase;
	Fixed			sound4Rate;
	long			sound4Phase;
	WavePtr			sound1Wave;
	WavePtr			sound2Wave;
	WavePtr			sound3Wave;
	WavePtr			sound4Wave;
};
typedef struct FTSoundRec FTSoundRec;

typedef FTSoundRec *FTSndRecPtr;

struct FTSynthRec {
	short			mode;
	FTSndRecPtr			sndRec;
};
typedef struct FTSynthRec FTSynthRec;

typedef FTSynthRec *FTSynthPtr;

typedef void (pascal *SndCompletionProcPtr)(void);

enum {
	uppSndCompletionProcInfo = kPascalStackBased
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr SndCompletionUPP;

#define CallSndCompletionProc(userRoutine)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppSndCompletionProcInfo)
#define NewSndCompletionProc(userRoutine)		\
		(SndCompletionUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppSndCompletionProcInfo, GetCurrentISA())
#else
typedef SndCompletionProcPtr SndCompletionUPP;

#define CallSndCompletionProc(userRoutine)		\
		(*(userRoutine))()
#define NewSndCompletionProc(userRoutine)		\
		(SndCompletionUPP)(userRoutine)
#endif


/*Structures for Sound Manager*/

struct SndCommand {
	unsigned short			cmd;
	short			param1;
	long			param2;
};
typedef struct SndCommand SndCommand;

typedef struct SndChannel SndChannel;

typedef SndChannel *SndChannelPtr;

typedef void (pascal *SndCallBackProcPtr)(SndChannelPtr chan, SndCommand *cmd);

enum {
	uppSndCallBackProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(SndChannelPtr)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(SndCommand*)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr SndCallBackUPP;

#define CallSndCallBackProc(userRoutine, chan, cmd)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppSndCallBackProcInfo, (chan), (cmd))
#define NewSndCallBackProc(userRoutine)		\
		(SndCallBackUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppSndCallBackProcInfo, GetCurrentISA())
#else
typedef SndCallBackProcPtr SndCallBackUPP;

#define CallSndCallBackProc(userRoutine, chan, cmd)		\
		(*(userRoutine))((chan), (cmd))
#define NewSndCallBackProc(userRoutine)		\
		(SndCallBackUPP)(userRoutine)
#endif

struct SndChannel {
	struct SndChannel			*nextChan;
	Ptr			firstMod;			/* reserved for the Sound Manager */
	SndCallBackUPP			callBack;
	long			userInfo;
	long			wait;			/* The following is for internal Sound Manager use only.*/
	SndCommand			cmdInProgress;
	short			flags;
	short			qLength;
	short			qHead;
	short			qTail;
	SndCommand			queue[stdQLength];
};
/*MACE structures*/

struct StateBlock {
	short			stateVar[stateBlockSize];
};
typedef struct StateBlock StateBlock;

typedef StateBlock *StateBlockPtr;

struct LeftOverBlock {
	unsigned long			count;
	char			sampleArea[leftOverBlockSize];
};
typedef struct LeftOverBlock LeftOverBlock;

typedef LeftOverBlock *LeftOverBlockPtr;

struct ModRef {
	unsigned short			modNumber;
	long			modInit;
};
typedef struct ModRef ModRef;

struct SndListResource {
	short			format;
	short			numModifiers;
	ModRef			modifierPart[1];			/*This is a variable length array*/
	short			numCommands;
	SndCommand			commandPart[1];			/*This is a variable length array*/
	char			dataPart[1];			/*This is a variable length array*/
};
typedef struct SndListResource SndListResource;

typedef SndListResource *SndListPtr;

typedef SndListPtr *SndListHndl, *SndListHandle;


/*HyperCard sound resource format*/

struct Snd2ListResource {
	short			format;
	short			refCount;
	short			numCommands;
	SndCommand			commandPart[1];			/*This is a variable length array*/
	char			dataPart[1];			/*This is a variable length array*/
};
typedef struct Snd2ListResource Snd2ListResource;

typedef Snd2ListResource *Snd2ListPtr;

typedef Snd2ListPtr *Snd2ListHndl;

struct SoundHeader {
	Ptr			samplePtr;			/*if NIL then samples are in sampleArea*/
	unsigned long			length;			/*length of sound in bytes*/
	Fixed			sampleRate;			/*sample rate for this sound*/
	unsigned long			loopStart;			/*start of looping portion*/
	unsigned long			loopEnd;			/*end of looping portion*/
	unsigned char			encode;			/*header encoding*/
	unsigned char			baseFrequency;			/*baseFrequency value*/
	unsigned char			sampleArea[1];			/*space for when samples follow directly*/
};
typedef struct SoundHeader SoundHeader;

typedef SoundHeader *SoundHeaderPtr;

struct CmpSoundHeader {
	Ptr			samplePtr;			/*if nil then samples are in sample area*/
	unsigned long			numChannels;			/*number of channels i.e. mono = 1*/
	Fixed			sampleRate;			/*sample rate in Apples Fixed point representation*/
	unsigned long			loopStart;			/*loopStart of sound before compression*/
	unsigned long			loopEnd;			/*loopEnd of sound before compression*/
	unsigned char			encode;			/*data structure used , stdSH, extSH, or cmpSH*/
	unsigned char			baseFrequency;			/*same meaning as regular SoundHeader*/
	unsigned long			numFrames;			/*length in frames ( packetFrames or sampleFrames )*/
	extended80			AIFFSampleRate;			/*IEEE sample rate*/
	Ptr			markerChunk;			/*sync track*/
	OSType			format;			/*data format type, was futureUse1*/
	unsigned long			futureUse2;			/*reserved by Apple*/
	StateBlockPtr			stateVars;			/*pointer to State Block*/
	LeftOverBlockPtr			leftOverSamples;			/*used to save truncated samples between compression calls*/
	unsigned short			compressionID;			/*0 means no compression, non zero means compressionID*/
	unsigned short			packetSize;			/*number of bits in compressed sample packet*/
	unsigned short			snthID;			/*resource ID of Sound Manager snth that contains NRT C/E*/
	unsigned short			sampleSize;			/*number of bits in non-compressed sample*/
	unsigned char			sampleArea[1];			/*space for when samples follow directly*/
};
typedef struct CmpSoundHeader CmpSoundHeader;

typedef CmpSoundHeader *CmpSoundHeaderPtr;

struct ExtSoundHeader {
	Ptr			samplePtr;			/*if nil then samples are in sample area*/
	unsigned long			numChannels;			/*number of channels,  ie mono = 1*/
	Fixed			sampleRate;			/*sample rate in Apples Fixed point representation*/
	unsigned long			loopStart;			/*same meaning as regular SoundHeader*/
	unsigned long			loopEnd;			/*same meaning as regular SoundHeader*/
	unsigned char			encode;			/*data structure used , stdSH, extSH, or cmpSH*/
	unsigned char			baseFrequency;			/*same meaning as regular SoundHeader*/
	unsigned long			numFrames;			/*length in total number of frames*/
	extended80			AIFFSampleRate;			/*IEEE sample rate*/
	Ptr			markerChunk;			/*sync track*/
	Ptr			instrumentChunks;			/*AIFF instrument chunks*/
	Ptr			AESRecording;
	unsigned short			sampleSize;			/*number of bits in sample*/
	unsigned short			futureUse1;			/*reserved by Apple*/
	unsigned long			futureUse2;			/*reserved by Apple*/
	unsigned long			futureUse3;			/*reserved by Apple*/
	unsigned long			futureUse4;			/*reserved by Apple*/
	unsigned char			sampleArea[1];			/*space for when samples follow directly*/
};
typedef struct ExtSoundHeader ExtSoundHeader;

typedef ExtSoundHeader *ExtSoundHeaderPtr;

struct ConversionBlock {
	short			destination;
	short			unused;
	CmpSoundHeaderPtr			inputPtr;
	CmpSoundHeaderPtr			outputPtr;
};
typedef struct ConversionBlock ConversionBlock;

typedef ConversionBlock *ConversionBlockPtr;

struct SMStatus {
	short			smMaxCPULoad;
	short			smNumChannels;
	short			smCurCPULoad;
};
typedef struct SMStatus SMStatus;

typedef SMStatus *SMStatusPtr;

struct SCStatus {
	Fixed			scStartTime;
	Fixed			scEndTime;
	Fixed			scCurrentTime;
	Boolean			scChannelBusy;
	Boolean			scChannelDisposed;
	Boolean			scChannelPaused;
	Boolean			scUnused;
	unsigned long			scChannelAttributes;
	long			scCPULoad;
};
typedef struct SCStatus SCStatus;

typedef SCStatus *SCStatusPtr;

struct AudioSelection {
	long			unitType;
	Fixed			selStart;
	Fixed			selEnd;
};
typedef void (pascal *FilePlayCompletionProcPtr)(SndChannelPtr chan);

enum {
	uppFilePlayCompletionProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(SndChannelPtr)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr FilePlayCompletionUPP;

#define CallFilePlayCompletionProc(userRoutine, chan)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppFilePlayCompletionProcInfo, (chan))
#define NewFilePlayCompletionProc(userRoutine)		\
		(FilePlayCompletionUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppFilePlayCompletionProcInfo, GetCurrentISA())
#else
typedef FilePlayCompletionProcPtr FilePlayCompletionUPP;

#define CallFilePlayCompletionProc(userRoutine, chan)		\
		(*(userRoutine))((chan))
#define NewFilePlayCompletionProc(userRoutine)		\
		(FilePlayCompletionUPP)(userRoutine)
#endif

typedef struct AudioSelection AudioSelection;

typedef AudioSelection *AudioSelectionPtr;

struct SndDoubleBuffer {
	long			dbNumFrames;
	long			dbFlags;
	long			dbUserInfo[2];
	char			dbSoundData[1];
};
typedef struct SndDoubleBuffer SndDoubleBuffer;

typedef SndDoubleBuffer *SndDoubleBufferPtr;

typedef void (pascal *SndDoubleBackProcPtr)(SndChannelPtr channel, SndDoubleBufferPtr doubleBufferPtr);

enum {
	uppSndDoubleBackProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(SndChannelPtr)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(SndDoubleBufferPtr)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr SndDoubleBackUPP;

#define CallSndDoubleBackProc(userRoutine, channel, doubleBufferPtr)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppSndDoubleBackProcInfo, (channel), (doubleBufferPtr))
#define NewSndDoubleBackProc(userRoutine)		\
		(SndDoubleBackUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), uppSndDoubleBackProcInfo, GetCurrentISA())
#else
typedef SndDoubleBackProcPtr SndDoubleBackUPP;

#define CallSndDoubleBackProc(userRoutine, channel, doubleBufferPtr)		\
		(*(userRoutine))((channel), (doubleBufferPtr))
#define NewSndDoubleBackProc(userRoutine)		\
		(SndDoubleBackUPP)(userRoutine)
#endif

struct SndDoubleBufferHeader {
	short			dbhNumChannels;
	short			dbhSampleSize;
	short			dbhCompressionID;
	short			dbhPacketSize;
	Fixed			dbhSampleRate;
	SndDoubleBufferPtr			dbhBufferPtr[2];
	SndDoubleBackUPP			dbhDoubleBack;
};
typedef struct SndDoubleBufferHeader SndDoubleBufferHeader;

typedef SndDoubleBufferHeader *SndDoubleBufferHeaderPtr;

struct SndDoubleBufferHeader2 {
	short			dbhNumChannels;
	short			dbhSampleSize;
	short			dbhCompressionID;
	short			dbhPacketSize;
	Fixed			dbhSampleRate;
	SndDoubleBufferPtr			dbhBufferPtr[2];
	SndDoubleBackUPP			dbhDoubleBack;
	OSType			dbhFormat;
};
typedef struct SndDoubleBufferHeader2 SndDoubleBufferHeader2;

typedef SndDoubleBufferHeader2 *SndDoubleBufferHeader2Ptr;

#ifdef __cplusplus
extern "C" {
#endif

extern OSErr pascal SndDoCommand(SndChannelPtr chan, const SndCommand *cmd, Boolean noWait);
extern OSErr pascal SndDoImmediate(SndChannelPtr chan, const SndCommand *cmd);
extern OSErr pascal SndNewChannel(SndChannelPtr *chan, short synth, long init, SndCallBackUPP userRoutine);
extern OSErr pascal SndDisposeChannel(SndChannelPtr chan, Boolean quietNow);
extern OSErr pascal SndPlay(SndChannelPtr chan, SndListHandle sndHdl, Boolean async);
extern OSErr pascal SndAddModifier(SndChannelPtr chan, Ptr modifier, short id, long init);
extern OSErr pascal SndControl(short id, SndCommand *cmd);
extern void pascal SetSoundVol(short level);

extern void pascal GetSoundVol(short *level);
extern NumVersion pascal SndSoundManagerVersion(void);
extern OSErr pascal SndStartFilePlay(SndChannelPtr chan, short fRefNum, short resNum, long bufferSize, void *theBuffer, AudioSelectionPtr theSelection, FilePlayCompletionUPP theCompletion, Boolean async);
extern OSErr pascal SndPauseFilePlay(SndChannelPtr chan);
extern OSErr pascal SndStopFilePlay(SndChannelPtr chan, Boolean quietNow);
extern OSErr pascal SndChannelStatus(SndChannelPtr chan, short theLength, SCStatusPtr theStatus);
extern OSErr pascal SndManagerStatus(short theLength, SMStatusPtr theStatus);
extern void pascal SndGetSysBeepState(short *sysBeepState);
extern OSErr pascal SndSetSysBeepState(short sysBeepState);
extern OSErr pascal SndPlayDoubleBuffer(SndChannelPtr chan, SndDoubleBufferHeaderPtr theParams);
extern NumVersion pascal MACEVersion(void);
extern void pascal Comp3to1(const void *inBuffer, void *outBuffer, unsigned long cnt, const void *inState, void *outState, unsigned long numChannels, unsigned long whichChannel);
extern void pascal Exp1to3(const void *inBuffer, void *outBuffer, unsigned long cnt, const void *inState, void *outState, unsigned long numChannels, unsigned long whichChannel);
extern void pascal Comp6to1(const void *inBuffer, void *outBuffer, unsigned long cnt, const void *inState, void *outState, unsigned long numChannels, unsigned long whichChannel);
extern void pascal Exp1to6(const void *inBuffer, void *outBuffer, unsigned long cnt, const void *inState, void *outState, unsigned long numChannels, unsigned long whichChannel);

/*Sound Manager 3.0 and later calls*/

extern OSErr pascal GetSysBeepVolume(long *level);
extern OSErr pascal SetSysBeepVolume(long level);
extern OSErr pascal GetDefaultOutputVolume(long *level);
extern OSErr pascal SetDefaultOutputVolume(long level);
extern OSErr pascal GetSoundHeaderOffset(Handle sndHandle, long *offset);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif


