/*
	File:		Terminals.h

	Copyright:	 1984-1993 by Apple Computer, Inc., all rights reserved.

	WARNING
	This file was auto generated by the interfacer tool. Modifications
	must be made to the master file.

*/

#ifndef __TERMINALS__
#define __TERMINALS__

#ifndef __DIALOGS__
#include <Dialogs.H>
#endif

#ifndef __CTBUTILITIES__
#if LONG_FILENAMES
#include <CTBUtilities.H>
#else
#include <CTBUtili.H>
#endif
#endif

#ifndef __CONNECTIONS__
#if LONG_FILENAMES
#include <Connections.H>
#else
#include <Connecti.H>
#endif
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

enum  {
/* current Terminal Manager version	*/
	curTMVersion			= 2,
/* current Terminal Manager Environment Record version	*/
	curTermEnvRecVers			= 0,
/* error codes	*/
	tmGenericError			= -1,
	tmNoErr			= 0,
	tmNotSent			= 1,
	tmEnvironsChanged			= 2,
	tmNotSupported			= 7,
	tmNoTools			= 8
};

typedef OSErr TMErr;

enum  {
	tmInvisible			= 1 << 0,
	tmSaveBeforeClear			= 1 << 1,
	tmNoMenus			= 1 << 2,
	tmAutoScroll			= 1 << 3,
	tmConfigChanged			= 1 << 4
};

typedef unsigned long TMFlags;

enum  {
	selTextNormal			= 1 << 0,
	selTextBoxed			= 1 << 1,
	selGraphicsMarquee			= 1 << 2,
	selGraphicsLasso			= 1 << 3,
	tmSearchNoDiacrit			= 1 << 8,
	tmSearchNoCase			= 1 << 9
};

typedef unsigned short TMSearchTypes;

typedef short TMSelTypes;

enum  {
	cursorText			= 1,
	cursorGraphics			= 2
};

typedef unsigned short TMCursorTypes;

enum  {
	tmTextTerminal			= 1 << 0,
	tmGraphicsTerminal			= 1 << 1
};

typedef unsigned short TMTermTypes;

struct TermDataBlock {
	TMTermTypes			flags;
	Handle			theData;
	Handle			auxData;
	long			reserved;
};
typedef struct TermDataBlock TermDataBlock;

typedef TermDataBlock *TermDataBlockPtr, **TermDataBlockH;

struct TermEnvironRec {
	short			version;
	TMTermTypes			termType;
	short			textRows;
	short			textCols;
	Point			cellSize;
	Rect			graphicSize;
	Point			slop;
	Rect			auxSpace;
};
typedef struct TermEnvironRec TermEnvironRec;

typedef TermEnvironRec *TermEnvironPtr;

union TMSelection {
	Rect			selRect;
	RgnHandle			selRgnHandle;
};
typedef union TMSelection TMSelection;

typedef struct TermRecord TermRecord, *TermPtr, **TermHandle;

typedef long (pascal *TerminalSendProcPtr)(Ptr thePtr, long theSize, long refCon, CMFlags flags);

enum {
	uppTerminalSendProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Ptr)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(CMFlags)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr TerminalSendUPP;

#define CallTerminalSendProc(userRoutine, thePtr, theSize, refCon, flags)		\
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppTerminalSendProcInfo, \
	(thePtr), (theSize), (refCon), (flags))
#define NewTerminalSendProc(userRoutine)		\
	(TerminalSendUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), \
	uppTerminalSendProcInfo, GetCurrentISA())
#else
typedef TerminalSendProcPtr TerminalSendUPP;

#define CallTerminalSendProc(userRoutine, thePtr, theSize, refCon, flags)		\
		(*(userRoutine))((thePtr), (theSize), (refCon), (flags))
#define NewTerminalSendProc(userRoutine)		\
		(TerminalSendUPP)(userRoutine)
#endif

typedef void (pascal *TerminalBreakProcPtr)(long duration, long refCon);

enum {
	uppTerminalBreakProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(long)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr TerminalBreakUPP;

#define CallTerminalBreakProc(userRoutine, duration, refCon)		\
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppTerminalBreakProcInfo, \
	(duration), (refCon))
#define NewTerminalBreakProc(userRoutine)	\
	(TerminalBreakUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), \
	uppTerminalBreakProcInfo, GetCurrentISA())
#else
typedef TerminalBreakProcPtr TerminalBreakUPP;

#define CallTerminalBreakProc(userRoutine, duration, refCon)		\
		(*(userRoutine))((duration), (refCon))
#define NewTerminalBreakProc(userRoutine)		\
		(TerminalBreakUPP)(userRoutine)
#endif

typedef long (pascal *TerminalCacheProcPtr)(long refCon, TermDataBlockPtr theTermData);

enum {
	uppTerminalCacheProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(TermDataBlockPtr)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr TerminalCacheUPP;

#define CallTerminalCacheProc(userRoutine, refCon, theTermData)		\
	CallUniversalProc((UniversalProcPtr)(userRoutine), uppTerminalCacheProcInfo, \
	(refCon), (theTermData))
#define NewTerminalCacheProc(userRoutine)		\
	(TerminalCacheUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), \
	uppTerminalCacheProcInfo, GetCurrentISA())
#else
typedef TerminalCacheProcPtr TerminalCacheUPP;

#define CallTerminalCacheProc(userRoutine, refCon, theTermData)		\
		(*(userRoutine))((refCon), (theTermData))
#define NewTerminalCacheProc(userRoutine)		\
		(TerminalCacheUPP)(userRoutine)
#endif

typedef void (pascal *TerminalSearchCallBackProcPtr)(TermHandle hTerm, short refNum, \
	Rect *foundRect);

enum {
	uppTerminalSearchCallBackProcInfo = kPascalStackBased
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(TermHandle)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(Rect*)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr TerminalSearchCallBackUPP;

#define CallTerminalSearchCallBackProc(userRoutine, hTerm, refNum, foundRect)		\
	CallUniversalProc((UniversalProcPtr)(userRoutine), \
	uppTerminalSearchCallBackProcInfo, (hTerm), (refNum), (foundRect))
#define NewTerminalSearchCallBackProc(userRoutine)		\
	(TerminalSearchCallBackUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), \
	uppTerminalSearchCallBackProcInfo, GetCurrentISA())
#else
typedef TerminalSearchCallBackProcPtr TerminalSearchCallBackUPP;

#define CallTerminalSearchCallBackProc(userRoutine, hTerm, refNum, foundRect)		\
		(*(userRoutine))((hTerm), (refNum), (foundRect))
#define NewTerminalSearchCallBackProc(userRoutine)		\
		(TerminalSearchCallBackUPP)(userRoutine)
#endif

typedef Boolean (pascal *TerminalClikLoopProcPtr)(long refCon);

enum {
	uppTerminalClikLoopProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(Boolean)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(long)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr TerminalClikLoopUPP;

#define CallTerminalClikLoopProc(userRoutine, refCon)		\
	CallUniversalProc((UniversalProcPtr)(userRoutine), \
	uppTerminalClikLoopProcInfo, (refCon))
#define NewTerminalClikLoopProc(userRoutine)		\
	(TerminalClikLoopUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), \
	uppTerminalClikLoopProcInfo, GetCurrentISA())
#else
typedef TerminalClikLoopProcPtr TerminalClikLoopUPP;

#define CallTerminalClikLoopProc(userRoutine, refCon)		\
		(*(userRoutine))((refCon))
#define NewTerminalClikLoopProc(userRoutine)		\
		(TerminalClikLoopUPP)(userRoutine)
#endif

typedef CMErr (pascal *TerminalEnvironsProcPtr)(long refCon, TermEnvironRec *theEnvirons);

enum {
	uppTerminalEnvironsProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(CMErr)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(TermEnvironRec*)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr TerminalEnvironsUPP;

#define CallTerminalEnvironsProc(userRoutine, refCon, theEnvirons)		\
	CallUniversalProc((UniversalProcPtr)(userRoutine), \
	uppTerminalEnvironsProcInfo, (refCon), (theEnvirons))
#define NewTerminalEnvironsProc(userRoutine)	\
	(TerminalEnvironsUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), \
	uppTerminalEnvironsProcInfo, GetCurrentISA())
#else
typedef TerminalEnvironsProcPtr TerminalEnvironsUPP;

#define CallTerminalEnvironsProc(userRoutine, refCon, theEnvirons)		\
		(*(userRoutine))((refCon), (theEnvirons))
#define NewTerminalEnvironsProc(userRoutine)		\
		(TerminalEnvironsUPP)(userRoutine)
#endif

typedef void (pascal *TerminalChooseIdleProcPtr)(void);

enum {
	uppTerminalChooseIdleProcInfo = kPascalStackBased
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr TerminalChooseIdleUPP;

#define CallTerminalChooseIdleProc(userRoutine)		\
		CallUniversalProc((UniversalProcPtr)(userRoutine), uppTerminalChooseIdleProcInfo)
#define NewTerminalChooseIdleProc(userRoutine)		\
	(TerminalChooseIdleUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), \
	uppTerminalChooseIdleProcInfo, GetCurrentISA())
#else
typedef TerminalChooseIdleProcPtr TerminalChooseIdleUPP;

#define CallTerminalChooseIdleProc(userRoutine)		\
		(*(userRoutine))()
#define NewTerminalChooseIdleProc(userRoutine)		\
		(TerminalChooseIdleUPP)(userRoutine)
#endif

typedef long (pascal *TerminalToolDefProcPtr)	\
	(TermHandle hTerm, short msg, long p1, long p2, long p3);

enum {
	uppTerminalToolDefProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(TermHandle)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(short)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(long)))
		| STACK_ROUTINE_PARAMETER(5, SIZE_CODE(sizeof(long)))
};

#if USESROUTINEDESCRIPTORS
typedef UniversalProcPtr TerminalToolDefUPP;

#define CallTerminalToolDefProc(userRoutine, hTerm, msg, p1, p2, p3)		\
	CallUniversalProc((UniversalProcPtr)(userRoutine), \
	uppTerminalToolDefProcInfo, (hTerm), (msg), (p1), (p2), (p3))
#define NewTerminalToolDefProc(userRoutine)		\
	(TerminalToolDefUPP) NewRoutineDescriptor((ProcPtr)(userRoutine), \
	uppTerminalToolDefProcInfo, GetCurrentISA())
#else
typedef TerminalToolDefProcPtr TerminalToolDefUPP;

#define CallTerminalToolDefProc(userRoutine, hTerm, msg, p1, p2, p3)		\
		(*(userRoutine))((hTerm), (msg), (p1), (p2), (p3))
#define NewTerminalToolDefProc(userRoutine)		\
		(TerminalToolDefUPP)(userRoutine)
#endif


/*	TMTermTypes	*/

struct TermRecord {
	short			procID;
	TMFlags			flags;
	TMErr			errCode;
	long			refCon;
	long			userData;
	TerminalToolDefUPP			defProc;
	Ptr			config;
	Ptr			oldConfig;
	TerminalEnvironsUPP			environsProc;
	long			reserved1;
	long			reserved2;
	Ptr			tmPrivate;
	TerminalSendUPP			sendProc;
	TerminalBreakUPP			breakProc;
	TerminalCacheUPP			cacheProc;
	TerminalClikLoopUPP			clikLoop;
	WindowPtr			owner;
	Rect			termRect;
	Rect			viewRect;
	Rect			visRect;
	long			lastIdle;
	TMSelection			selection;
	TMSelTypes			selType;
	long			mluField;
};
#ifdef __cplusplus
extern "C" {
#endif


extern TMErr pascal InitTM(void);
extern Handle pascal TMGetVersion(TermHandle hTerm);
extern short pascal TMGetTMVersion(void);
extern TermHandle pascal TMNew(const Rect *termRect, const Rect *viewRect, \
	TMFlags flags, short procID, WindowPtr owner, TerminalSendUPP sendProc, \
	TerminalCacheUPP cacheProc, TerminalBreakUPP breakProc, \
	TerminalClikLoopUPP clikLoop, TerminalEnvironsUPP environsProc, \
	long refCon, long userData);
extern void pascal TMDispose(TermHandle hTerm);
extern void pascal TMKey(TermHandle hTerm, const EventRecord *theEvent);
extern void pascal TMUpdate(TermHandle hTerm, RgnHandle visRgn);
extern void pascal TMPaint(TermHandle hTerm, const TermDataBlock *theTermData, \
	const Rect *theRect);
extern void pascal TMActivate(TermHandle hTerm, Boolean activate);
extern void pascal TMResume(TermHandle hTerm, Boolean resume);
extern void pascal TMClick(TermHandle hTerm, const EventRecord *theEvent);
extern void pascal TMIdle(TermHandle hTerm);
extern long pascal TMStream(TermHandle hTerm, void *theBuffer, long theLength, \
	CMFlags flags);
extern Boolean pascal TMMenu(TermHandle hTerm, short menuID, short item);
extern void pascal TMReset(TermHandle hTerm);
extern void pascal TMClear(TermHandle hTerm);
extern void pascal TMResize(TermHandle hTerm, const Rect *newViewRect);
extern long pascal TMGetSelect(TermHandle hTerm, Handle theData, ResType *theType);
extern void pascal TMGetLine(TermHandle hTerm, short lineNo, TermDataBlock *theTermData);
extern void pascal TMSetSelection(TermHandle hTerm, const TMSelection *theSelection, \
	TMSelTypes selType);
extern void pascal TMScroll(TermHandle hTerm, short dh, short dv);
extern Boolean pascal TMValidate(TermHandle hTerm);
extern void pascal TMDefault(Ptr *theConfig, short procID, Boolean allocate);
extern Handle pascal TMSetupPreflight(short procID, long *magicCookie);
extern void pascal TMSetupSetup(short procID, const void *theConfig, short count, \
	DialogPtr theDialog, long *magicCookie);
extern Boolean pascal TMSetupFilter(short procID, const void *theConfig, short count, \
	DialogPtr theDialog, EventRecord *theEvent, short *theItem, long *magicCookie);
extern void pascal TMSetupItem(short procID, const void *theConfig, short count, \
	DialogPtr theDialog, short *theItem, long *magicCookie);
extern void pascal TMSetupXCleanup(short procID, const void *theConfig, short count, \
	DialogPtr theDialog, Boolean OKed, long *magicCookie);
extern void pascal TMSetupPostflight(short procID);
extern Ptr pascal TMGetConfig(TermHandle hTerm);
extern short pascal TMSetConfig(TermHandle hTerm, const void *thePtr);
extern OSErr pascal TMIntlToEnglish(TermHandle hTerm, const void *inputPtr, \
	Ptr *outputPtr, short language);
extern OSErr pascal TMEnglishToIntl(TermHandle hTerm, const void *inputPtr, \
	Ptr *outputPtr, short language);
extern void pascal TMGetToolName(short id, Str255 name);
extern short pascal TMGetProcID(ConstStr255Param name);
extern void pascal TMSetRefCon(TermHandle hTerm, long refCon);
extern long pascal TMGetRefCon(TermHandle hTerm);
extern void pascal TMSetUserData(TermHandle hTerm, long userData);
extern long pascal TMGetUserData(TermHandle hTerm);
extern short pascal TMAddSearch(TermHandle hTerm, ConstStr255Param theString, \
	const Rect *where, TMSearchTypes searchType, TerminalSearchCallBackUPP callBack);
extern void pascal TMRemoveSearch(TermHandle hTerm, short refnum);
extern void pascal TMClearSearch(TermHandle hTerm);
extern Point pascal TMGetCursor(TermHandle hTerm, TMCursorTypes cursType);
extern TMErr pascal TMGetTermEnvirons(TermHandle hTerm, TermEnvironRec *theEnvirons);
extern short pascal TMChoose(TermHandle *hTerm, Point where, TerminalChooseIdleUPP idleProc);
extern void pascal TMEvent(TermHandle hTerm, const EventRecord *theEvent);
extern Boolean pascal TMDoTermKey(TermHandle hTerm, ConstStr255Param theKey);
extern short pascal TMCountTermKeys(TermHandle hTerm);
extern void pascal TMGetIndTermKey(TermHandle hTerm, short id, Str255 theKey);
extern void pascal TMGetErrorString(TermHandle hTerm, short id, Str255 errMsg);
#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif


