//%attributes = {}
//******************************************************************************
//Method: SDA_ClipboardPaste
//Written by  Tod Gentille on 10/19/1998
//
//Purpose: Paste in the contents of the clipboard and support
//text and pict based on what the type of the variable that
//is being pointed to
//
//$1 -pointer to variable to paste
//$2 -boolean if true do a timed wait for the operation

//
//Copyright 1998 Syncor Systems, Inc.
//******************************************************************************
C_POINTER:C301($1; $pVarForOperation)
C_BOOLEAN:C305($2; $bTimedWait)
C_BOOLEAN:C305($0)
C_TEXT:C284($tClipboardDataType)

$pVarForOperation:=$1
$tClipboardDataType:=SDA_ClipboardGetDataType($pVarForOperation)
$bTimedWait:=$2

$0:=True:C214

Case of   //clipboard data type
		
	: ($tClipboardDataType=Text data:K20:2)
		SET TEXT TO PASTEBOARD:C523($pVarForOperation->)
		
	: ($tClipboardDataType=Picture data:K20:3)
		SET PICTURE TO PASTEBOARD:C521($pVarForOperation->)
		
	Else   //unrecognized clipboard data type
		$0:=False:C215
End case   //Case of   `clipboard data type

If ($0)  //if we did a successful load of the clipboard
	SDA_util_PostKey(<>SDA_ASCII_PASTE_KEY; Command key mask:K16:1; $bTimedWait)
	
Else   //unsuccessful load of clipboard
	//unrecognized data type on clipboard    
	SDA_util_BugAlert(<>SDA_UNEXPECTED_PARAM; " Method: SDA_ClipboardPaste"; $tClipboardDataType)
End if   //If ($0)  `if we did a successful load of the clipboard
