//%attributes = {}
//******************************************************************************
//Method: SDA_CommentRemove
//Written by  Tod Gentille on 9/24/1998
//
//Purpose: Remove the comment char if it is the first char (after white space)
//of the line in the passed selection of lines
//$1 pointer to array of source lines
//$2 pointer to array of destination lines
//$0 - return text variable of concatenated destination lines
//Copyright 1998 Syncor Systems, Inc.
//
//******************************************************************************
C_POINTER:C301($1; $paSourceLines)
C_POINTER:C301($2; $paDestinationLines)
C_TEXT:C284($0)

C_LONGINT:C283($iArraySize; $iDestIdx; $i)
C_TEXT:C284($tCurrentLine)

$paSourceLines:=$1
$paDestinationLines:=$2

$iArraySize:=Size of array:C274($paSourceLines->)
ARRAY TEXT:C222($paDestinationLines->; $iArraysize)
$iDestIdx:=0

For ($i; 1; $iArraySize)
	//Strip off leading non breaking spaces 
	$tCurrentLine:=SDA_util_StripWhiteSpace($paSourceLines->{$i})
	
	//First just strip off the comment character      
	If ($tCurrentLine[[1]]=<>SDA_COMMENT_CHAR)
		$tCurrentLine:=Substring:C12($tCurrentLine; 2)
	End if 
	
	//Now look and see if there is a continuation character and if so
	//remove it and the CR from the previous line      
	If ($tCurrentLine[[1]]=<>SDA_COMMENT_CONTINUATION_CHAR)  //then this line was originally part of the previous line
		$tCurrentLine:=Substring:C12($tCurrentLine; 2)  //strip off the continuation character
		If ($i>1)  //if there is a previous line
			//remove the CR from the previous line        
			$paDestinationLines->{$i-1}:=Substring:C12($paDestinationLines->{$i-1}; 1; Length:C16($paDestinationLines->{$i-1})-1)
		Else   //no previous line          
			//user may want to modify this else case to put up a warning          
			//Syncor felt this may be bothersome but in effect the user
			//may have uncommented only have the line of code they intended to
		End if 
	End if 
	
	//save the current line in the array
	$paDestinationLines->{$i}:=$tCurrentLine
	
End for 

//Build the method back up from the array elements    
$0:=""
For ($i; 1; $iArraySize)
	$0:=$0+$paDestinationLines->{$i}
End for 
