//%attributes = {}
//******************************************************************************
//
//Method: SDA_GetFieldInfo
//
//Written by  Tod Gentille on 12/2/97
//
//Purpose: Using the currently highlighted text in a method determine if it is
//a valid [Table]FieldName value and return the field information about it
//if it is not a valid reference put up an error message
//
//NOTE: Uses the 4D EXECUTE command and installs and ON ERR CALL and then clears 
//it
//Copyright 1997 Syncor Systems, Inc.
//
//******************************************************************************
C_BOOLEAN:C305($bNoError)
C_LONGINT:C283(iFieldNum_L; iTableNum_L)  //local in scope but used via Execute
C_TEXT:C284($tFieldInfo; $tTableField)

$tFieldInfo:=""

SDA_ClipboardOps(<>SDA_COPY; -><>tSDA_Scrap)

$tTableField:="->"+<>tSDA_Scrap
$bNoError:=SDA_util_Execute("iTableNum_L:=Table("+$tTableField+")")

If (iTableNum_L=0)
	$bNoError:=False:C215
End if 

If ($bNoError)
	$bNoError:=SDA_util_Execute("iFieldNum_L:=Field("+$tTableField+")")
End if 

If ($bNoError)
	
	If (iFieldNum_L#0)
		$tFieldInfo:=SDA_FieldVerboseInfo(iTableNum_L; iFieldNum_L; True:C214)
		$tFieldInfo:=$tFieldInfo+(Char:C90(Carriage return:K15:38))+"Table Number is "+String:C10(iTableNum_L)+" Field number is "+String:C10(iFieldNum_L)
	Else   //no field num, we were passed just a table name
		
		$tFieldInfo:="Table Number is "+String:C10(iTableNum_L)
	End if 
	
	
	_info_ ALERT(<>tSDA_Scrap+" is of type: "+$tFieldInfo)
Else 
	_info_ ALERT("The text "+Char:C90(Double quote:K15:41)+<>tSDA_Scrap+Char:C90(Double quote:K15:41)+" is Invalid."+" You must highlight a valid [Table]Fieldname before using this function.")
End if 
