//%attributes = {}
//******************************************************************************
//Method: SDA_ResEditor
//Written by  Cyril Harnisch on 2/5/99
//
//Purpose: Present the resource editor window to the developer. This allows the
// developer to create, rename and delete resources of type "4DK#". Other
// resource types can be added by the developer, if desired but different data
// types add complexity to the interface. Also, a resource can be selected
// and its elements can be created, edited and deleted. The resource editor
// function is provided under the assumption that the developer understands
// resources and how to use them.
//
//Copyright 1999 Syncor Systems, Inc.
//******************************************************************************
C_BLOB:C604(<>oSDA_Konstant)
C_BOOLEAN:C305($bWindowsStructure; $bAllPassed)
C_LONGINT:C283(<>lSDA_4DK_ID)  //could be local except we pass a pointer to  it
C_LONGINT:C283(lbResourceList; lbResourceIDList)
C_POINTER:C301(<>pSDA_ResEdtrFormObject)
_O_C_STRING:C293(4; $s4ResourceType)
_O_C_STRING:C293(32; <>s32SDA_ResourceName)
_O_C_STRING:C293(80; <>s80ResEditorTitle)
_O_C_STRING:C293(254; <>SDA_s254Resource_L; <>SDA_s254ResourceP_L)
C_TEXT:C284(<>tResEditorInstruction)
C_TEXT:C284($tFileName)
C_TIME:C306(<>hSDA_DocRef)

_O_ARRAY STRING:C218(254; <>as254SDA_KonstantStrings_L; 0)
_O_ARRAY STRING:C218(4; <>a4SDA_ResourceType; 2)
<>a4SDA_ResourceType{1}:="4DK#"
<>a4SDA_ResourceType{2}:="STR#"
<>a4SDA_ResourceType:=2  //set to 4DK

If (Application type:C494=4D Remote mode:K5:5) | (Application type:C494=4D Server:K5:6)  //if platform is client/server
	_info_ ALERT("Cannot run Resource Editor in client/server mode.")
	
Else   //not 4D server  
	$tFileName:=Structure file:C489
	$s4ResourceType:="4DK#"  //start with the 4DK# resources
	
	If (Position:C15(".4DB"; $tFileName)#0)  //if the structure has .4DB, it is hosted on windows
		$tFileName:=Replace string:C233($tFileName; ".4DB"; ".RSR")  //we want the resource fork
		$bWindowsStructure:=True:C214
		
	Else   //running on a Mac
		$bWindowsStructure:=False:C215
	End if   //  If (Position(".4DB";$tFileName) # 0)  `if the structure has .4DB, it is hosted
	
	//This case statement is a technique for avoiding nested ifs. As long as each 
	//case returns true the next case will exectue. If everything works the Else claus
	//will execute and reset $bGo to true so that we know everything worked
	$bAllPassed:=False:C215
	
	Case of   //check that resource is open and accessable
			
		: (Not:C34(SDA_ResourceFileOpen($tFileName; -><>hSDA_DocRef)))  //Open the resource fork of the structure
			
		: (Not:C34(SDA_4DK_GetResourceID(-><>lSDA_4DK_ID; $s4ResourceType; <>hSDA_DocRef)))  //have the user pick a 4DK resource
			
		Else 
			$bAllPassed:=True:C214
	End case   //  Case of   `check that resource is open and accessable
	
	If ($bAllPassed)
		//Save the name of the chosen resource    
		<>s32SDA_ResourceName:=<>as254SDA_KonstantStrings_L{<>as254SDA_KonstantStrings_L}
		$s4ResourceType:=<>a4SDA_ResourceType{<>a4SDA_ResourceType}  //get the resource type the use selected
		//Read in the selected resource into a blob and parse it into array  
		SDA_ResEd4DK_Read(<>lSDA_4DK_ID; -><>oSDA_Konstant; -><>as254SDA_KonstantStrings_L; <>hSDA_DocRef; $s4ResourceType)
		
		//Display the array in an area list or other means to allow user to edit 
		<>s80ResEditorTitle:="Resource String Editor"
		DIALOG:C40("SDA_ResEditor")
		CLOSE WINDOW:C154  //close the resource editor window
	End if   //  If ($bAllPassed)
	
	CLOSE RESOURCE FILE:C498(<>hSDA_DocRef)
End if   //If (Application type=4D Client) | (Application type=4D Server)  `if platform is 
