//%attributes = {}
//******************************************************************************
//Method: SDA_ResEditorScripts
//Written by  Cyril Harnisch on 2/6/99
//
//Purpose: Handle the code for various scripts on the Resource
// Editor form. This uses parameter 1 to determine which object was
// active. Since this fom is used for both the resource and the resource
// elements listing, separate scripts are driven from most objects.
//
//$1 - pointer-pointer referencing the object which was active on the
// Resource Editor form
//$2 - pointer-form event variable
//
//Copyright 1999 Syncor Systems, Inc.
//******************************************************************************
C_POINTER:C301($1; $2; $pPtrObject; $pFormEvent)
C_POINTER:C301($pNil)

$pPtrObject:=$1
$pFormEvent:=$2

Case of   //different Resource Editor form objects
		
	: ($pPtrObject->=(-><>as254SDA_KonstantStrings_L)) | ($pPtrObject->=(-><>alSDA_ResourceIDs))  //if the resource array
		OBJECT SET ENTERABLE:C238(<>SDA_s254Resource_L; (<>as254SDA_KonstantStrings_L>0))  //make this enterable once the user has selected a resource
		
		If (<>s80ResEditorTitle=(<>s30SDA_RES_ELE_EDTR_WINDW_NAME+"@"))  //if in the string editor          
			SDA_ResEditorResStrLstScript($pPtrObject; $pFormEvent; <>hSDA_DocRef; <>lSDA_4DK_ID; -><>oSDA_Konstant; <>a4SDA_ResourceType{<>a4SDA_ResourceType})
			$pPtrObject->:=$pNil  //clear the object pointer
			
		Else   //the resource editor
			
			If ($pFormEvent->=On Double Clicked:K2:5)  //if the user double clicked
				
				If (<>as254SDA_KonstantStrings_L{<>as254SDA_KonstantStrings_L}=<>s30SDA_NEW_RES_DEFAULT_NAME)  //if the user double clicked on a resource with the default name
					BEEP:C151
					_info_ ALERT("You cannot add elements to this resource until you rename it.")
					$pFormEvent->:=0  //indicate we are finished processing this event
					$pPtrObject->:=$pNil  //clear the object pointer
					OBJECT SET TITLE:C194(lbDone; "Edit")
					
				Else   //user double clicked on a resource with the valid name
					$pPtrObject->:=(->lbDone)  //indicate we would like to process the done button
					$pFormEvent->:=On Clicked:K2:4  //Change to a single click
					//Can't clear the object pointer here because that keeps the double-click
					// option from working       
				End if   //        If (<>as254SDA_KonstantStrings_L{<>as254SDA_KonstantStrings_L}=<>SDA_RES
				
			Else   //the user did not double click
				SDA_ResEditorResLstScript($pPtrObject; $pFormEvent; <>hSDA_DocRef; -><>alSDA_ResourceIDs; -><>oSDA_Konstant; <>a4SDA_ResourceType{<>a4SDA_ResourceType})
			End if   //      If ($pFormEvent->=On Double Clicked)  `if the user double clicked
			
		End if   //    If (<>s80ResEditorTitle=(<>s30SDA_RES_ELE_EDTR_WINDW_NAME+"@"))  `if in the 
		
	: ($pPtrObject->=(->lbAdd))  //if the add button
		SDA_ResEditorAddBtnScript($pFormEvent)
		OBJECT SET ENTERABLE:C238(<>SDA_s254Resource_L; (<>as254SDA_KonstantStrings_L>0))  //make this enterable once the user has selected a resource
		$pPtrObject->:=$pNil  //clear the object pointer
		
	: ($pPtrObject->=(->lbApply))  //if the apply button
		$pFormEvent->:=0  //indicate we are finished processing this event
		$pPtrObject->:=$pNil  //clear the object pointer
		
		If (<>s80ResEditorTitle=(<>s30SDA_RES_ELE_EDTR_WINDW_NAME+"@"))  //if in the string editor          
			SDA_CheckResStrChangeSave(-><>SDA_s254ResourceP_L; -><>SDA_s254Resource_L; <>hSDA_DocRef; <>lSDA_4DK_ID; -><>oSDA_Konstant; -><>as254SDA_KonstantStrings_L; <>a4SDA_ResourceType{<>a4SDA_ResourceType}; False:C215)
			
		Else   //the resource editor
			//this should not happen
		End if   //    If (<>s80ResEditorTitle=(<>s30SDA_RES_ELE_EDTR_WINDW_NAME+"@"))  `if in the 
		
	: ($pPtrObject->=(->lbDelete))  //if the delete button   
		
		If (<>s80ResEditorTitle=(<>s30SDA_RES_ELE_EDTR_WINDW_NAME+"@"))  //if in the string editor    
			SDA_CheckResStrDelete(-><>SDA_s254ResourceP_L; -><>SDA_s254Resource_L; <>hSDA_DocRef; <>lSDA_4DK_ID; -><>oSDA_Konstant; -><>as254SDA_KonstantStrings_L; <>a4SDA_ResourceType{<>a4SDA_ResourceType})
			$pFormEvent->:=0  //indicate we are finished processing this event     
			$pPtrObject->:=$pNil  //clear the object pointer
			
		Else   //the resource editor
			SDA_CheckResDelete(-><>SDA_s254ResourceP_L; -><>SDA_s254Resource_L; <>hSDA_DocRef; -><>alSDA_ResourceIDs; -><>oSDA_Konstant; -><>as254SDA_KonstantStrings_L; <>a4SDA_ResourceType{<>a4SDA_ResourceType})
			$pFormEvent->:=0  //indicate we are finished processing this event     
			$pPtrObject->:=$pNil  //clear the object pointer
		End if   //    If (<>s80ResEditorTitle=(<>s30SDA_RES_ELE_EDTR_WINDW_NAME+"@"))  `if in the 
		
	: ($pPtrObject->=(->lbDone))  //if the done button   
		
		If (<>s80ResEditorTitle=(<>s30SDA_RES_ELE_EDTR_WINDW_NAME+"@"))  //if in the string editor    
			SDA_CheckResStrChangeSave(-><>SDA_s254ResourceP_L; -><>SDA_s254Resource_L; <>hSDA_DocRef; <>lSDA_4DK_ID; -><>oSDA_Konstant; -><>as254SDA_KonstantStrings_L; <>a4SDA_ResourceType{<>a4SDA_ResourceType})
			ACCEPT:C269
			$pFormEvent->:=0  //indicate we are finished processing this event     
			$pPtrObject->:=$pNil  //clear the object pointer
			
		Else   //the resource editor
			SDA_CheckResChangeSave(-><>SDA_s254ResourceP_L; -><>SDA_s254Resource_L; <>hSDA_DocRef; -><>alSDA_ResourceIDs; -><>oSDA_Konstant; -><>as254SDA_KonstantStrings_L; <>a4SDA_ResourceType{<>a4SDA_ResourceType})
			$pFormEvent->:=0  //indicate we are finished processing this event
			$pPtrObject->:=$pNil  //clear the object pointer
			
			Case of   //edit or cancel button clicked
					
				: (<>as254SDA_KonstantStrings_L=0)  //if no resource was selected
					CANCEL:C270  //the user clicked on the cancel button          
					
				: (<>as254SDA_KonstantStrings_L{<>as254SDA_KonstantStrings_L}=<>s30SDA_NEW_RES_DEFAULT_NAME)  //if the default name has not been changed
					BEEP:C151
					_info_ ALERT("You cannot add elements to this resource until you rename it.")
					
				Else   //user clicked on a resource with a valid name
					ACCEPT:C269
			End case   //      Case of   `edit or cancel button clicked
			
		End if   //    If (<>s80ResEditorTitle=(<>s30SDA_RES_ELE_EDTR_WINDW_NAME+"@"))  `if in the 
		
	: ($pPtrObject->=(->lbEscape))  //if the escape button
		$pPtrObject->:=(->lbDone)  //indicate we would like to process the done button & don't
		// change the event variable
		
	: ($pPtrObject->=(->lbReturn))  //if the return button
		$pPtrObject->:=(->lbDone)  //indicate we would like to process the done button & don't
		// change the event variable
		
	: ($pPtrObject->=(-><>a4SDA_ResourceType))  //if the resources type drop-down
		
		If (<>s80ResEditorTitle=(<>s30SDA_RES_ELE_EDTR_WINDW_NAME+"@"))  //if in the string editor    
			BEEP:C151  //this should not happen since this element is hidden on the string editor form
			$pFormEvent->:=0  //indicate we are finished processing this event     
			$pPtrObject->:=$pNil  //clear the object pointer
			
		Else   //the resource editor
			SDA_ResEditorSetUp(<>a4SDA_ResourceType{<>a4SDA_ResourceType}; <>hSDA_DocRef)
			<>as254SDA_KonstantStrings_L:=0  //make sure no resource is selected
			<>SDA_s254ResourceP_L:=""  //clear selections
			<>SDA_s254Resource_L:=""
			OBJECT SET ENTERABLE:C238(<>SDA_s254Resource_L; False:C215)  //make not enterable until user selects a resource
			OBJECT SET TITLE:C194(lbDone; "Cancel")
			$pFormEvent->:=0  //indicate we are finished processing this event     
			$pPtrObject->:=$pNil  //clear the object pointer
		End if   //    If (<>s80ResEditorTitle=(<>s30SDA_RES_ELE_EDTR_WINDW_NAME+"@"))  `if in the 
		
	: ($pPtrObject->=(->lbResourceList))  //if the resource list header button
		
		If (False:C215 & (<>s80ResEditorTitle=(<>s30SDA_RES_ELE_EDTR_WINDW_NAME+"@")))  //if in the string editor          
			
			If (Windows Alt down:C563)  //if the alt (opt) key was held down
				SORT ARRAY:C229(<>as254SDA_KonstantStrings_L; <)  //sort descending      
				
			Else   //alt not held down
				SORT ARRAY:C229(<>as254SDA_KonstantStrings_L; >)  //sort ascending      
			End if   //      If (Windows Alt down)  `if the alt (opt) key was held down
			
		Else   //in the resource editor
			
			If (Windows Alt down:C563)  //if the alt (opt) key was held down
				SORT ARRAY:C229(<>as254SDA_KonstantStrings_L; <>alSDA_ResourceIDs; <)  //sort descending      
				
			Else   //alt not held down
				SORT ARRAY:C229(<>as254SDA_KonstantStrings_L; <>alSDA_ResourceIDs; >)  //sort ascending      
			End if   //      If (Windows Alt down)  `if the alt (opt) key was held down
			
		End if   //    If (<>s80ResEditorTitle=(<>s30SDA_RES_ELE_EDTR_WINDW_NAME+"@"))  `if in the 
		
		$pFormEvent->:=0  //indicate we are finished processing this event     
		$pPtrObject->:=$pNil  //clear the object pointer
		
	: ($pPtrObject->=(->lbResourceIDList))  //if the resource list header button
		
		If (Windows Alt down:C563)  //if the alt (opt) key was held down
			SORT ARRAY:C229(<>alSDA_ResourceIDs; <>as254SDA_KonstantStrings_L; <)  //sort descending      
			
		Else   //alt not held down
			SORT ARRAY:C229(<>alSDA_ResourceIDs; <>as254SDA_KonstantStrings_L; >)  //sort ascending      
		End if   //    If (Windows Alt down)  `if the alt (opt) key was held down
		
		$pFormEvent->:=0  //indicate we are finished processing this event     
		$pPtrObject->:=$pNil  //clear the object pointer
		
	Else   //unrecognized object
		$pFormEvent->:=0  //indicate we are finished processing this event
		$pPtrObject->:=$pNil  //clear the object pointer
End case   //Case of   `different Resource Editor form objects
