//%attributes = {}
//******************************************************************************
//
//Method: SDA_SimilarClose
//
//Written by  Tod Gentille on 12/4/97
//
//Purpose: Close all windows whose name starts with the user entered string
//the string is defaulted to the name of the frontmost window
//
//Copyright 1997 Syncor Systems, Inc.
//
//******************************************************************************
C_TEXT:C284($tWinTitle; $tStartsWith)
C_LONGINT:C283($lCurWinRef)
ARRAY LONGINT:C221($alWinRef; 0)
C_LONGINT:C283($lWnd)

WINDOW LIST:C442($alWinRef)

If (SDA_util_ProcessCheck#0)  //if front most window is in the design environment
	$tWinTitle:=SDA_util_GetWinTitleStripped
	$tStartsWith:=_info_ Request(<>SDA_CLOSE_PROMPT; $tWinTitle)
	
	If (OK=1)  //if user hit OK
		
		For ($lWnd; 1; Size of array:C274($alWinRef))  //for each window
			$lCurWinRef:=$alWinRef{$lWnd}
			SDA_util_BringWinToFront($lCurWinRef)
			
			Case of   //valid & matching window
					
				: (Not:C34(SDA_util_IsValidWindowType(True:C214; $lCurWinRef)))  //make sure it is a method editor window
					
				: (Not:C34(SDA_util_IsMatchingWindowTitle($tStartsWith)))
					
				Else   //not valid & matching window
					SDA_util_CloseWindowWait
			End case   //      Case of   `valid & matching window
			
		End for   //    For ($lWnd;1;Size of array($alWinRef))  `for each window
		//
	End if   //  If (OK=1)  `if user hit OK
	//
End if   //If (SDA_util_ProcessCheck  # 0)  `if front most window is in the design environm
