//%attributes = {}
//******************************************************************************
//Method: SDA_TableFieldListInit(pListRef)
//Written by  Tod Gentille on 10/14/97
//
//Purpose: Initialize the table Field popup used in the design palette. Called fro
//the on load phase of the popup  which calls SDA_TableFieldPopup which calls us
//
//$1 - pointer to a list ref to use for table/fields
//
//Copyright 1997 Syncor Systems, Inc.
//
//******************************************************************************
C_POINTER:C301($1; $pTableFieldList)
C_LONGINT:C283($MAX_LIST_CHARS)
C_LONGINT:C283($CHARS_FOR_FULLNAMES)
C_LONGINT:C283($lrFieldList)
C_LONGINT:C283($iListRefCtr; $iListParentCtr)
C_LONGINT:C283($i; $j)
C_TEXT:C284($tTableName; $tFieldName)
C_LONGINT:C283(<>iTABLE_OFFSET; <>iTABLE_DESIGNATOR; $iListTableOffset)

$pTableFieldList:=$1

<>iTABLE_OFFSET:=1000
<>iTABLE_DESIGNATOR:=999
//The next two local vars are ideal candidates for 4DK#
$MAX_LIST_CHARS:=31  //This is how many chars we have in the current version of 4D hierarchical lists
$CHARS_FOR_FULLNAMES:=64  //this is how many characters we need to show full [table]field names

//Build Hierarchical list from the ground up. 
//Create unique numbers for all list and sublists based on table and field numbers
$pTableFieldList->:=New list:C375
$iListRefCtr:=0  //the counter used to give every item a unique number

For ($i; 1; _tbl_ Count)
	$iListRefCtr:=$i  //$iListRefCtr+1
	$iListParentCtr:=$iListRefCtr  //save the table list ref # for assignment in the outer loop APPEND TO LIST
	
	//Create the sublist to hold the fields for this table  
	$lrFieldList:=New list:C375
	$iListTableOffset:=$iListRefCtr*<>iTABLE_OFFSET  //This allows us to easily retrieve the table number
	$iListRefCtr:=$iListTableOffset+<>iTABLE_DESIGNATOR  //special number for the first item which is just the table name
	
	$tTableName:=" ["+Table name:C256($i)+"]"
	If (<>bSDA_TableFieldExtraInfo)
		$tTableName:=$tTableName+" #"+String:C10($i; "00")  //add the table num to the display
	End if 
	//Right now lists only take 31 chars, so limit our text item to 31 even though
	//if you don't do this it seems to just truncate
	$tFieldName:=Substring:C12($tTableName; 1; $MAX_LIST_CHARS)
	
	APPEND TO LIST:C376($lrFieldList; $tTableName; $iListRefCtr)  //the first item in the field sublist is always the table name
	
	For ($j; 1; Get last field number:C255($i))
		$iListRefCtr:=$iListTableOffset+$j  //
		//Modified by Tod Gentille on 3/3/98 just put in the field name because we only 
		//31 characters to work with in a hierarchical list
		//NOTE: if you want you can show the table and field for those that fit. I prefer
		//to have a consistent look. So if it is possible that any [Table]Fieldname won't 
		//fit I don't show any of them. The paste routine doesn't use what is in the popup
		//to paste in the table field name so don't worry about what you show in the popup
		If ($MAX_LIST_CHARS<$CHARS_FOR_FULLNAMES)  //just in case the max length ever changes
			$tFieldName:=Field name:C257($i; $j)
			If (<>bSDA_TableFieldExtraInfo)
				$tFieldName:=$tFieldName+" #"+String:C10($j; "00")  //add the field number to the display
				$tFieldName:=$tFieldName+":"+SDA_FieldVerboseInfo($i; $j; <>bSDA_VerboseFieldInfo)  //make param 3 true to get long description info
			End if 
			
		Else   //if we have enough chars in a list then show everything
			$tFieldName:=$tTableName+Field name:C257($i; $j)
		End if 
		
		//Limit our text item to max characters even though
		//if you don't do this it seems to just truncate
		$tFieldName:=Substring:C12($tFieldName; 1; $MAX_LIST_CHARS)
		APPEND TO LIST:C376($lrFieldList; $tFieldName; $iListRefCtr)
	End for 
	
	APPEND TO LIST:C376($pTableFieldList->; Table name:C256($i); $iListParentCtr; $lrFieldList; True:C214)
	
End for 

SORT LIST:C391($pTableFieldList->)
//
//The docs say the next line will select item 1 because 0 is out of range
//but in fact it does deselect any item. That way if the first time the user
//drags off the hier. popup without selecting anything nothing gets pasted
//if we don't do this we always get an item from the list pasted in   
SELECT LIST ITEMS BY POSITION:C381($pTableFieldList->; 0)

//put a comment here so Insider will copy this method correctly
