//%attributes = {}
//_prli_SetHeaders(Area;StartCol;NumCol;Headers1-N or DelimitedHdrs)

//Part of the PrintTwist(tm) component by Business Brothers, Inc.
//Written by Tony Ringsmuth

//VARIATION FROM PrintList: Headers can be passed as 
//   $4 through $N
//  OR, as $4: text delimited by semi-colons.

//Rev: 03/23/07:  `If too many hdrs are passed, then give grace if top most hdrs 
//       are blank

//--------------------------------------------------------------------------------
C_LONGINT:C283($1; $_prli_iAreaRef; $2; $_prli_iStartCol; $3; $_prli_iOpts; $_prli_iNumCol)
C_TEXT:C284(${4})
C_BOOLEAN:C305(_prli_bRunAsWrapper)

$_prli_iAreaRef:=$1
$_prli_iStartCol:=$2
$_prli_iOpts:=$3

$_prli_NoErrorAlertOnTooManyHea:=($_prli_iOpts ?? 8)  //+256

If (_prli_bRunAsWrapper)
	ARRAY TEXT:C222($_prli_aExecText; 10)
	ARRAY INTEGER:C220($_prli_aExecColBeg; 10)
	ARRAY INTEGER:C220($_prli_aExecNumCols; 10)
	$_prli_iExecElement:=1
	$_prli_iExecCtr:=0
End if 

$_prli_iFindArea:=_prli_Util_FindAreaRef($_prli_iAreaRef; Current method name:C684)
If ($_prli_iFindArea>-1)
	
	If ($_prli_iStartCol=0)
		$_prli_iStartCol:=1
	End if 
	
	ARRAY TEXT:C222($_prli_aHeaders; 0)
	If ((Count parameters:C259=4) & (Position:C15(";"; $4)>0))
		ARRAY TEXT:C222(_prli_aUtilText; 0)
		_prli_Util_TextToArray($4; ->_prli_aUtilText; ";")
		COPY ARRAY:C226(_prli_aUtilText; $_prli_aHeaders)
		ARRAY TEXT:C222(_prli_aUtilText; 0)
	Else 
		ARRAY TEXT:C222($_prli_aHeaders; Count parameters:C259-3)
		For ($_prli_iPrmCtr; 4; Count parameters:C259)
			$_prli_aHeaders{$_prli_iPrmCtr-3}:=${$_prli_iPrmCtr}
		End for 
	End if 
	
	$_prli_iNumCol:=Size of array:C274($_prli_aHeaders)
	
	//If too many hdrs are passed, then give grace if top most hdrs are blank.
	Repeat 
		$_prli_Stop:=True:C214
		If (($_prli_iStartCol+$_prli_iNumCol-1)>Size of array:C274(_prli_aArray{$_prli_iFindArea}))
			If (Length:C16($_prli_aHeaders{$_prli_iNumCol})=0)
				DELETE FROM ARRAY:C228($_prli_aHeaders; $_prli_iNumCol)
				$_prli_iNumCol:=Size of array:C274($_prli_aHeaders)
				$_prli_Stop:=False:C215
			End if 
		End if 
	Until ($_prli_Stop)
	
	If (($_prli_iStartCol+$_prli_iNumCol-1)>Size of array:C274(_prli_aArray{$_prli_iFindArea}))
		If ($_prli_NoErrorAlertOnTooManyHea=False:C215)
			_info_ ALERT("More headers were passed than the number of columns that exist."+Char:C90(13)+Current method name:C684)
		End if 
		$_prli_iNumCol:=Size of array:C274(_prli_aArray{$_prli_iFindArea})-$_prli_iStartCol
	End if 
	
	$_prli_iOldColCnt:=Size of array:C274(_prli_aHeader{$_prli_iFindArea})
	$_prli_iAddElements:=($_prli_iStartCol+$_prli_iNumCol-1)-$_prli_iOldColCnt
	If ($_prli_iAddElements>0)
		INSERT IN ARRAY:C227(_prli_aHeader{$_prli_iFindArea}; $_prli_iOldColCnt; $_prli_iAddElements)
	End if 
	
	For ($_prli_iCntArray; 1; $_prli_iNumCol)
		$_prli_iColNum:=$_prli_iStartCol+$_prli_iCntArray-1
		_prli_aHeader{$_prli_iFindArea}{$_prli_iColNum}:=$_prli_aHeaders{$_prli_iCntArray}
		
		If (_prli_bRunAsWrapper)
			$_prli_iExecCtr:=$_prli_iExecCtr+1
			If ($_prli_iExecCtr>14)
				$_prli_iExecElement:=$_prli_iExecElement+1
				$_prli_iExecCtr:=0
				$_prli_aExecColBeg{$_prli_iExecElement}:=$_prli_iColNum
			End if 
			$_prli_aExecText{$_prli_iExecElement}:=$_prli_aExecText{$_prli_iExecElement}+Char:C90(34)+$_prli_aHeaders{$_prli_iCntArray}+Char:C90(34)+";"
			$_prli_aExecNumCols{$_prli_iExecElement}:=$_prli_aExecNumCols{$_prli_iExecElement}+1
		End if 
		
	End for 
	
End if 

If (_prli_bRunAsWrapper & ($_prli_iNumCol>0))
	$_prli_aExecColBeg{1}:=$_prli_iStartCol
	For ($_prli_iCtr; 1; $_prli_iExecElement)
		$_prli_Execute:="_prli_SetHeaders ("+_prli_Util_AreaRefString($_prli_iAreaRef)+";"+String:C10($_prli_aExecColBeg{$_prli_iCtr})+";"+String:C10($_prli_aExecNumCols{$_prli_iCtr})+";"+Substring:C12($_prli_aExecText{$_prli_iCtr}; 1; Length:C16($_prli_aExecText{$_prli_iCtr})-1)+")"
		_prli_Util_QueuePLCode($_prli_iAreaRef; $_prli_Execute)
	End for 
End if 
