//%attributes = {}
If (False:C215)
	//_prli_Util_SizeArrayGroup(Size;->ArrayGroup)
	
	//Part of the PrintTwist(tm) component by Business Brothers, Inc.
	//Written by Tony Ringsmuth
	
	//Rev: 11/19/02: Coding Improvements
	//Rev: 09/20/00: If -1 is passed in $1, then also size $2 to zero when finished.
	//Rev: 05/19/00: Test for undefined $2
	//Rev: 05/16/00: Skip error on undefined arrays if Size is zero.
	//Rev: 12/01/99: More explicit error logging on 2d error
	
	//FUNCTION:
	//  Makes the arrays ($2 - $x+1) the same size (the size of $1).
	
	//PARAMETERS:
	//  $1 =  array size.
	//  $2  = PointerArray: points to arrays to be resized.  Pointers.
	
	//If -1 is passed in $1, then also size $2 to zero when finished.
End if 
//
C_LONGINT:C283($1; $_prli_iTableNum; $_prli_iFieldNum; $_prli_iSetSizeTo; $_prli_iSize; $_prli_iOldSize; $_prli_iAddElements; $_prli_iType)
C_POINTER:C301($2; $_prli_Ptr; $_prli_BaseArray)
C_TEXT:C284($_prli_varName)
//
$_prli_iSetSizeTo:=$1
$_prli_ClearGroupArray:=($_prli_iSetSizeTo=-1)
If ($_prli_ClearGroupArray)
	$_prli_iSetSizeTo:=0
End if 


If ($_prli_iSetSizeTo<0)
	_prli_Util_ErrorAlert("$1 is negative."+Char:C90(13)+"$1 = "+String:C10($1)+", $2 = "+_prli_Util_PtrName($2); Current method name:C684)
	$_prli_iSetSizeTo:=0
End if 

If (Type:C295($2->)=Is undefined:K8:13)
	_prli_Util_ErrorAlert("$2: "+_prli_Util_PtrName($2)+" was undefined: will attenpt an Array Pointer Definition."; Current method name:C684)
	ARRAY POINTER:C280($2->; 0)
End if 

For ($_prli_iArrayCtr; 1; Size of array:C274($2->))
	$_prli_Ptr:=$2->{$_prli_iArrayCtr}
	
	//Are we trying to size an array within a 2D array for which the element
	//  does not exist?
	RESOLVE POINTER:C394($_prli_Ptr; $_prli_varName; $_prli_iTableNum; $_prli_iFieldNum)
	$_prli_2dArrSizeErr:=False:C215
	If ($_prli_iTableNum#-1)
		$_prli_BaseArray:=Get pointer:C304($_prli_varName)
		If (Size of array:C274($_prli_BaseArray->)<$_prli_iTableNum)
			$_prli_2dArrSizeErr:=True:C214
		End if 
	End if 
	
	If ($_prli_2dArrSizeErr)
		$_prli_it:="2D Array size error: "+$_prli_varName+"{"+String:C10($_prli_iTableNum)+"},  size of "+$_prli_varName+" = "+String:C10(Size of array:C274($_prli_BaseArray->))+": Sizing to "+String:C10($_prli_iSetSizeTo)
		If ($_prli_iSetSizeTo=0)
			_prli_Util_ErrorAlert($_prli_it+Char:C90(13)+"User not alerted."; Current method name:C684)  //If we're sizing to Zero, don't tell the user; just log it.
		Else 
			_prli_Util_ErrorAlert($_prli_it; Current method name:C684)
		End if 
	Else 
		
		$_prli_iType:=Type:C295($_prli_Ptr->)
		
		Case of 
			: ($_prli_iType=Is undefined:K8:13)
				If ($_prli_iSetSizeTo=0)
					//do nothing
				Else 
					_prli_Util_ErrorAlert("The Array is undefined: "+_prli_Util_PtrName($_prli_Ptr); Current method name:C684)
				End if 
				
				//List every existing array type here
			: (($_prli_iType=Array 2D:K8:24) | ($_prli_iType=Boolean array:K8:21) | ($_prli_iType=Date array:K8:20) | ($_prli_iType=Integer array:K8:18) | ($_prli_iType=LongInt array:K8:19) | ($_prli_iType=Picture array:K8:22) | ($_prli_iType=Pointer array:K8:23) | ($_prli_iType=Real array:K8:17) | ($_prli_iType=String array:K8:15) | ($_prli_iType=Text array:K8:16))
				
				
				$_prli_iOldSize:=Size of array:C274($_prli_Ptr->)
				$_prli_iAddElements:=$_prli_iSetSizeTo-$_prli_iOldSize
				Case of 
					: ($_prli_iAddElements<0)
						DELETE FROM ARRAY:C228($_prli_Ptr->; $_prli_iOldSize+1+$_prli_iAddElements; -$_prli_iAddElements)
					: ($_prli_iAddElements>0)
						INSERT IN ARRAY:C227($_prli_Ptr->; $_prli_iOldSize+1; $_prli_iAddElements)
				End case 
				
			Else 
				
				_prli_Util_ErrorAlert("Tried to size "+$_prli_varName+" as an array."; Current method name:C684)
				
		End case 
		
	End if   //($2dArrSizeErr)
End for 

If ($_prli_ClearGroupArray)
	$_prli_iSize:=Size of array:C274($2->)
	If ($_prli_iSize>0)
		DELETE FROM ARRAY:C228($2->; 1; $_prli_iSize)
	End if 
End if 
