//%attributes = {}

// Project Method: Calendar_PlaceBoxes

// Searching for answers? Be sure to check out the "About..." menu located in the
// Apple menu (Macintosh) or the Help menu (Windows). There you can find online
// help for this example database, as well as a listing of numerous 4D resources
// available to you.

// Method created by Dave Batton, DataCraft

// This method moves around the boxes (text variables without text) and the 
//   numbers on top of them.


C_LONGINT:C283($cal_lBoxLeft; $cal_lBoxTop; $cal_lBoxBottom; $cal_lBoxRight; cal_lBoxWidth; cal_lBoxHeight; $cal_lBoxSpacing)
C_LONGINT:C283($cal_lWinLeft; $cal_lWinTop; $cal_lWinRight; $cal_lWinBottom)
C_LONGINT:C283($cal_lRow; $cal_lRowCount; $cal_lCol; $cal_lColCount; $cal_lObjectNum)
_O_C_STRING:C293(2; $cal_lObjectNumStr)
C_DATE:C307(cal_dCurrentDate; $cal_dBoxDate)
C_POINTER:C301($cal_pWeek)

cal_dCurrentDate:=_date Current(kTrue)  //speed optimization
$cal_lBoxLeft:=cal_lLeftMargin
$cal_lBoxTop:=cal_lTopMargin

Case of 
	: ((cal_lShowSaturday=kTrue) & (cal_lShowSunday=kTrue))
		$cal_lColCount:=7
	: ((cal_lShowSaturday=kTrue) & (cal_lShowSunday=kFalse))
		$cal_lColCount:=6
	: ((cal_lShowSaturday=kFalse) & (cal_lShowSunday=kTrue))
		$cal_lColCount:=6
		<>cal_lFirstShownDayNumber:=Sunday:K10:19  //=1  ` if saturday is not shown, show sunday first
	: ((cal_lShowSaturday=kFalse) & (cal_lShowSunday=kFalse))
		$cal_lColCount:=5
End case 

Case of 
	: (cal_lWeekMode<0)  // day
		$cal_lRowCount:=1
		$cal_lColCount:=1
	: (cal_lWeekMode=0)  // month 
		// Determine if we need five or six rows to display the selected month.    
		If (cal_lLastBox<=35)
			$cal_lRowCount:=5
		Else 
			$cal_lRowCount:=6
		End if 
	: (cal_lWeekMode>6)  // error, 1-6 weeks
		cal_lWeekMode:=6
		$cal_lRowCount:=cal_lWeekMode
	Else 
		$cal_lRowCount:=cal_lWeekMode
End case 

// move boxes offscreen
OBJECT MOVE:C664(*; "Box@"; 5000; 5000; 5005; 5005; *)
OBJECT MOVE:C664(*; "Day@"; 5000; 5000; 5005; 5005; *)
OBJECT MOVE:C664(*; "Week@"; 5000; 5000; 5005; 5005; *)
OBJECT MOVE:C664(*; "Number@"; 5000; 5000; 5005; 5005; *)

GET WINDOW RECT:C443($cal_lWinLeft; $cal_lWinTop; $cal_lWinRight; $cal_lWinBottom)
cal_lBoxWidth:=($cal_lWinRight-$cal_lWinLeft-cal_lLeftMargin-cal_lRightMargin-(($cal_lColCount-1)*cal_lColumnWidth))/$cal_lColCount

cal_lBoxHeight:=($cal_lWinBottom-$cal_lWinTop-cal_lTopMargin-cal_lBottomMargin-(($cal_lRowCount-1)*cal_lColumnHeight))/$cal_lRowCount
$cal_lBoxTop:=cal_lTopMargin
$cal_lBoxLeft:=cal_lLeftMargin

For ($cal_lRow; 1; $cal_lRowCount)
	$cal_lBoxBottom:=$cal_lBoxTop+cal_lBoxHeight
	For ($cal_lCol; 1; $cal_lColCount)
		$cal_lBoxRight:=$cal_lBoxLeft+cal_lBoxWidth
		
		$cal_lObjectNum:=(($cal_lRow-1)*$cal_lColCount)+$cal_lCol
		$cal_lObjectNumStr:=String:C10($cal_lObjectNum)
		
		// If the current box isn't used to display a date in the current month, set it to
		//   the dark color. Otherwise, set it to the light color.
		$cal_dBoxDate:=cal_BoxDateGet($cal_lObjectNum)
		Case of 
			: (cal_dCurrentDate=$cal_dBoxDate)  //PM: 2005-09-07
				OBJECT SET RGB COLORS:C628(*; "Box"+$cal_lObjectNumStr; cal_lBoxColorDark; cal_lBoxColorToday)
			: (($cal_lObjectNum<cal_lFirstBox) | ($cal_lObjectNum>cal_lLastBox))
				OBJECT SET RGB COLORS:C628(*; "Box"+$cal_lObjectNumStr; cal_lBoxColorDark; cal_lBoxColorDarkBackground)
			Else 
				OBJECT SET RGB COLORS:C628(*; "Box"+$cal_lObjectNumStr; cal_lBoxColorDark; cal_lBoxColorLight)
		End case 
		
		// $cal_lBoxRight:=$cal_lBoxLeft+cal_lBoxWidth
		// $cal_lBoxBottom:=$cal_lBoxTop+cal_lBoxHeight
		
		// Move the object to its correct position.
		OBJECT MOVE:C664(*; "Box"+$cal_lObjectNumStr; $cal_lBoxLeft; $cal_lBoxTop; $cal_lBoxRight; $cal_lBoxBottom; *)
		OBJECT MOVE:C664(*; "Number"+$cal_lObjectNumStr; $cal_lBoxLeft; $cal_lBoxTop+3; $cal_lBoxRight-4; $cal_lBoxTop+3+14; *)
		If ($cal_lRow=1)  //move day names
			OBJECT MOVE:C664(*; "Day"+$cal_lObjectNumStr; $cal_lBoxLeft; $cal_lBoxTop-15; $cal_lBoxRight; $cal_lBoxTop-2; *)
		End if 
		If ($cal_lCol=1)  //move week names
			$cal_pWeek:=Get pointer:C304("cal_tWeek"+String:C10($cal_lRow))
			$cal_pWeek->:=String:C10(_date ToWeek($cal_dBoxDate)-(Year of:C25($cal_dBoxDate)*100))  //only week number
			OBJECT MOVE:C664(*; "Week"+String:C10($cal_lRow); $cal_lBoxLeft-26; $cal_lBoxTop; $cal_lBoxLeft-4; $cal_lBoxTop+14; *)
		End if 
		$cal_lBoxLeft:=$cal_lBoxLeft+cal_lBoxWidth+cal_lColumnWidth
	End for 
	$cal_lBoxLeft:=cal_lLeftMargin
	
	// If we need only five rows to display the month, move the last row offscreen.
	//  If (($cal_lRow=5) & ($cal_lRowCount=5))
	//    $cal_lBoxTop:=$cal_lWinBottom+2000
	//  Else 
	//    $cal_lBoxTop:=$cal_lBoxTop+cal_lBoxHeight+cal_lColumnHeight
	//  End if 
	$cal_lBoxTop:=$cal_lBoxTop+cal_lBoxHeight+cal_lColumnHeight
End for 

// Some IP vars we'll use elsewhere.
cal_lLeft:=cal_lLeftMargin
cal_lRight:=cal_lLeft+(cal_lBoxWidth*7)+(cal_lColumnWidth*6)
cal_lTop:=cal_lTopMargin
cal_lBottom:=cal_lTop+(cal_lBoxHeight*$cal_lRowCount)+(cal_lColumnHeight*($cal_lRowCount-1))
