//%attributes = {}
// Method: sor_wo_UPDATE
// 2008.12.30-17:20:52 / Arto Kokkila
// © Copyright 2008 Manage Applications
// Purpose: 
// Update sor ordered amount to work order
// ------------------------------------------------------------
C_TEXT:C284($sor_tProductionLot; $sor_tWoState; $sor_tWork; $sor_tCompanyId)
C_REAL:C285($sor_rStartedAmount)
C_LONGINT:C283($sor_lOK)

Case of 
	: (<>sor_lUpdateWorkOrderAmount=1)
		$sor_lOK:=_info_ Confirm(_lang Current("Do you want to update ordered amount to work order?"))
		If ($sor_lOK=kYes)
			$sor_lOK:=kTrue
		Else 
			$sor_lOK:=kFalse
		End if 
	: (<>sor_lUpdateWorkOrderAmount=2)
		$sor_lOK:=kTrue
	Else 
		$sor_lOK:=kFalse
End case 

If ($sor_lOK=kTrue)
	$sor_tProductionLot:=_fld ValueStr(sor_kProduction_Lot)
	If ($sor_tProductionLot#"")
		_sel RELATE_ONE(pr_kProduct_ID; sor_kProduct_id)
		COMPILER_pr
		If (_fld ValueLong(pr_kProduction_Control_Type)=<>pr_stlim_lProdCtrlType_Order)
			COMPILER_wo
			_txt:=$sor_tProductionLot
			_qry Fld(0; wo_kProduction_Lot; "="; ->_txt; ""; kFalse)
			If (_sel RecsInSel(wo_kTbl)>0)
				$sor_tWoState:=_fld ValueStr(wo_kState)
				If (wo_ IsOpenState($sor_tWoState)=kTrue)
					$sor_rStartedAmount:=_fld ValueReal(sor_kOrdered_Amount)
					$sor_rWoStartedAmount:=_fld ValueReal(wo_kStarted_Amount)
					If ($sor_rStartedAmount#$sor_rWoStartedAmount)
						_tbl WRITE_STATE(wo_kTbl; kTrue)
						_rec LOCKED_WAIT(wo_kTbl; kTrue)
						If (OK=0)
							_err MESSAGE(_lang Current("Work Order was locked")+" ("+$sor_tProductionLot+")"+ksCR+_lang Current("Sales order row ordered amount was not saved to work order"); Current method name:C684; kFalse)
						Else 
							//$sor_rWoRemainingAmount:=_fld ValueReal (wo_kf)
							_fld VALUE_REAL_SET(kSet; wo_kStarted_Amount; $sor_rStartedAmount)
							xapp TblRun(wo_kStarted_Amount; wo_kTbl; kNoEvent)
							_rec SAVE(wo_kTbl)
							If (OK=0)
								_err MESSAGE(_lang Current("Work Order was not saved because of unknown error")+" ("+$sor_tProductionLot+")"+ksCR+_lang Current("Sales order row ordered amount was not saved to work order"); Current method name:C684; kFalse)
							Else 
								_sel RELATE_ONE(so_kSales_Order_ID; sor_kSales_Order_id)
								$sor_tWork:=_fld ValueStr(wo_kWork__Position_Num_id)
								$sor_tCompanyId:=_fld ValueStr(so_kCompany_id)
								wo_WOS_VALUES_UPDATE($sor_tProductionLot; $sor_tWork; $sor_rStartedAmount; $sor_tCompanyId)
							End if 
							
						End if 
						_tbl WRITE_STATE(wo_kTbl; kPrevious)
					End if 
				End if 
			End if 
		End if 
	End if 
End if 

