rowsLoaded.value = 0
rowsInSelection.value = 0
rowsInTable.value = 0
const rowsLoadedArr = []
const preloadCount = 75
const rowLoadBatchHalfSize = 100
const rowViewportPrev = {}
const rowUpdateCalled = false

function updateToolbar(rec, pop) {
	var key, rec2, val
	rec2 = {}
	for (key in rec) {
		val = rec[key]
		if (key === 'tab' || key.search('order') >= 0) {
			// ?
		} else if (key === 'field') {
			rec2.field = val
		} else {
			rec2[key] = val
		}
	}
	mainState.updateToolbar(rec2, pop)
}

function onSort(field, ascend) {
	callParam.order_field = field
	if (ascend) {
		callParam.order_ascend = '>'
	} else {
		callParam.order_ascend = '<'
	}
	nc.deleteParam('nc-selection_' + rec.table) // saveParam()
	if (rowsLoaded.value === rowsInSelection.value) {
		// false and
		return true // better to use db sort always
	}
	callServer('load')
	return false // do not let grid do it's default sort
}

function gridOnRedraw(area, newScopeData) {
	var add
	updateSortIndicator()
	if (rowsInSelection.value > rowsLoaded.value && newScopeData.data.length < rowsInSelection.value) {
		console.log('gridOnRedraw change:', rowsLoaded.value, rowsInSelection.value, newScopeData.data.length)
		add = rowsInSelection.value - rowsLoaded.value
		if (newScopeData.data.length > rowsLoaded.value) {
			add = rowsInSelection.value - newScopeData.data.length
		}
		return add
	}
	return null
}

function setQueryField(order_field) {
	callParam.field = '["' + order_field + '"]'
	updateToolbar({
		field: callParam.field
	})
	return saveParam()
}

function updateSortIndicator() {
	grid = state.grid.list
	if (grid.setSortColumn && callParam.order_field !== '') {
		if (callParam.order_ascend === '>') {
			return grid.setSortColumn(callParam.order_field, true)
		} else if (callParam.order_ascend === '<') {
			return grid.setSortColumn(callParam.order_field, false)
		}
	}
}

function triggerAction(action, option) {
	var deleteCallback, docName, docType, idArr, ok, param, printCallback, save, selectionToStructureCallback
	param = {}
	if (!option || option !== 'no-selection') {
		idArr = selectedIdArr()
		if (idArr === null || idArr.length < 1) {
			alert('select record(s) for action: ' + action)
			return
		}
		param.selection = idArr
	}
	if (option) {
		param.option = option
	}
	param.rec.table = rec.table
	console.log('nc-list-form: triggerMenu()', action, param)
	if (action === 'delete') {
		ok = false
		if (idArr.length === 1) {
			ok = confirm('Do you really want to delete 1 record?')
		} else {
			ok = confirm('Do you really want to delete ' + idArr.length + ' records?')
		}
		if (ok) {
			callParam.tab = state.rec.tab
			deleteCallback = function (ret) {
				return callServer('query', callParam.tab)
			}
			return nc.callServer(state, action, param, deleteCallback)
		}
	} else if (action.search('download') === 0) {
		return nc.callServer(state, action, param, ret => {
			var txt
			txt = nc.toJson(ret.selection)
			return mainState.showTextDialog(txt)
		})
		// else if action is "upload"
		// nc.callServer(state, action, param, selectionToStructureCallback)
	} else if (action.search('print') === 0) {
		docName = option.report_name
		docType = option.document_type
		save = option.save || false
		printCallback = function (ret) {
			// if nc.isSafari()
			//   mainState.showPictureDialog(data)
			// else
			//   blob = new Blob([data], {'type': "image/svg+xml"})
			//   url = URL.createObjectURL(blob)
			//   win = window.open(url, docName)
			//   win.focus()

			var blob, data, ref, url, win
			data = ret != null ? ((ref = ret.rec) != null ? ref.picture : void 0) : void 0
			if (!data) {
				// show error message?
				return
			}
			docName = docName + '.' + docType
			if (docType === 'svg') {
				mainState.showPictureDialog(data)
			} else {
				blob = nc.base64toBlob(data, 'application/' + docType)
				if (save || nc.isSafari()) {
					// window.location = url
					saveAs(blob, docName)
				} else {
					url = URL.createObjectURL(blob)
					win = window.open(url, docName) // , title ,'_blank')
					// win.document.write("<title>" + docName + "." + docType + "</title>")
					if (win) {
						win.focus()
					} else {
						nc.info(state, 'Opening window for print failed, allow popup windows for this url to see report in browser.')
					}
				}
			}
		}
		nc.callServer(state, action, param, printCallback)
	} else {
		nc.callServer(state, action, param) // , selectionToStructureCallback)
	}
}

function modifyRecord() {
	var url
	saveParam()
	url = rec.table + '_input1'
	console.log(url)
	nc.gotoUrl(state, 'input/modify')
}

function gridOnSelectedRowsChangedCallback(e, args) {
	// item = args.grid.getData()[args.row]
	// console.log('gridOnSelectedRowsChangedCallback: ', args, e) #, item)
	saveParam()
}

function viewportChanged(vp, preload) {
	var bottom, i, limit, param, prevTop, top, up
	prevTop = rowViewportPrev.top
	top = vp.top
	bottom = vp.bottom
	rowViewportPrev.top = top
	rowViewportPrev.bottom = bottom
	if (!rowUpdateCalled) {
		up = top < prevTop
		if (bottom > rowsInSelection.value - 1) {
			// bottom is 0-based
			bottom = rowsInSelection.value - 1
		}
		i = 0
		while (i < rowsLoadedArr.length) {
			if (top >= rowsLoadedArr[i].top && bottom <= rowsLoadedArr[i].bottom) {
				if (preload) {
					if (up && top - rowsLoadedArr[i].top <= preloadCount) {
						// start loading rows before top == has time to load before drawing
						top = rowsLoadedArr[i].top
						if (top <= 0) {
							// no scroll before first row
							return
						}
						break // do load
					}
					if (!up && rowsLoadedArr[i].bottom - bottom <= preloadCount) {
						bottom = rowsLoadedArr[i].bottom
						if (bottom >= rowsInSelection.value - 1) {
							// no scroll after last row
							return
						}
						break // is in loaded range, do nothing
					}
				}
				return
			}
			i = i + 1
		}
		if (i >= rowsLoadedArr.length) {
			// not inside any block, search near block
			i = 0
			while (i < rowsLoadedArr.length) {
				// fill small gaps
				if (up && top <= rowsLoadedArr[i].top && rowsLoadedArr[i].top - top <= rowLoadBatchHalfSize) {
					// debugger
					top = rowsLoadedArr[i].top
					break
				}
				if (!up && bottom >= rowsLoadedArr[i].bottom && bottom - rowsLoadedArr[i].bottom <= rowLoadBatchHalfSize) {
					// debugger
					bottom = rowsLoadedArr[i].bottom
					break
				}
				i = i + 1
			}
		}
		rowUpdateCalled = true
		console.log('gridOnViewportChanged:', top, rowViewportPrev.top, bottom, rowViewportPrev.bottom)
		param = {}
		param.add_to_grid = {}
		param.add_to_grid.up = up
		limit = 0 // set limit, bottom -> next top
		if (i >= rowsLoadedArr.length) {
			// not inside any block or near any block, moved by mouse in scrollbar
			// load half of data up and half down from scroll point because we don't know the next direction
			param.add_to_grid.offset = top - 1 - rowLoadBatchHalfSize
		} else if (up) {
			param.add_to_grid.offset = top - 1
		} else {
			param.add_to_grid.offset = bottom + 1
		}
		param.add_to_grid.limit = limit
		callServer('load', param)
	}
}

function gridOnViewportChanged(e, args) {
	const vp = args.grid.getViewport()
	viewportChanged(vp, true)
}

function loadRows(param) {
	var bottom, i, top
	if (state.grid && state.grid.list) {
		state.grid.list.rec.table = rec.table
		if (!state.grid.list.callback) {
			state.grid.list.callback = {}
			state.grid.list.callback.onSelectedRowsChanged = gridOnSelectedRowsChangedCallback
			state.grid.list.callback.onDblClick = gridOnDblClick
			state.grid.list.callback.onViewportChanged = gridOnViewportChanged
			state.grid.list.callback.onRedraw = gridOnRedraw
			state.grid.list.callback.onSort = onSort
		}
	}
	if (param.load_batch_size) {
		// debugger
		rowLoadBatchHalfSize = Math.floor(param.load_batch_size / 2)
		if (param.preload_count) {
			preloadCount = param.preload_count
		}
	}
	if (param.info) {
		rowsInSelection.value = param.info.rowCountTotal
		rowsInTable.value = param.info.rowCountTable
		if (rowsLoaded.value === 0 && param.grid && param.grid.list && param.grid.list.data) {
			rowsLoaded.value = param.grid.list.data.length // param.info.rowCount
			rowsLoadedArr = []
			rowsLoadedArr.push({
				top: 0,
				bottom: rowsLoaded.value - 1
			})
		}
		if (param.add_to_grid && param.grid_data.length > 0) {
			grid.beginUpdate()
			top = param.add_to_grid.offset // array index is 0-based
			i = 0
			while (i < param.grid_data.length) {
				grid.data[top + i] = param.grid_data[i]
				grid.data[top + i].id = top + i + 1 // id is 1-based
				i++
			}
			bottom = top + i - 1
			grid.endUpdate()
			grid.updateRowCount()
			// debugger
			grid.refreshRows()
			i = 0
			while (i < rowsLoadedArr.length) {
				// make previous block bigger
				if (top <= rowsLoadedArr[i].bottom + 1 && bottom >= rowsLoadedArr[i].top - 1) {
					// debugger
					if (top < rowsLoadedArr[i].top) {
						rowsLoadedArr[i].top = top
					}
					if (bottom > rowsLoadedArr[i].bottom) {
						rowsLoadedArr[i].bottom = bottom
					}
					break
				} else if (bottom < rowsLoadedArr[i].top) {
					rowsLoadedArr.splice(i, 0, {
						top: top,
						bottom: bottom // insert in array
					})
					break
				}
				i++
			}
			if (i >= rowsLoadedArr.length) {
				// new block
				rowsLoadedArr.push({
					top: top,
					bottom: bottom
				})
			}
			rowsLoaded.value = rowsLoaded.value + param.grid_data.length
			rowUpdateCalled = false
			// check if current viewport is loaded after previous load
			if (rowViewportPrev.top) {
				viewportChanged(rowViewportPrev, false)
			}
		}
		rowUpdateCalled = false // must be also here to recover from errors
		// debugger
		if (param.rec) {
			if (param.rec.order_field && param.rec.order_ascend) {
				if (param.rec.order_field !== callParam.order_field || param.rec.order_ascend !== callParam.order_ascend) {
					callParam.order_ascend = param.rec.order_ascend
					callParam.order_field = param.rec.order_field
					updateSortIndicator()
				}
			}
		}
		if (!param.add_to_grid && grid && grid.redrawRows) {
			return grid.redrawRows()
		}
	}
}
