//%attributes = {}
//******************************************************************************
//Method:SDA_CaseBuildList
//Written by  Tod Gentille on 10/14/97
//
//Purpose: Build a list of all the case statements in the current method window
//NOTE: Creates <>atSDA_CaseDesc array for holding popup menu items
//Commented out case statements are found and included in the popup
//
//Copyright 1998 Syncor Systems, Inc.
//
//Modified by Tod Gentille on 4/20/98 SDA Version 2.0
//Enforces max num of characters for a popup
//Checks that select all and copy work before building list
//Modified 8/21/98 use more named constants 
//Modified by: Cyril Harnisch, Syncor Systems, Inc., 2/9/99
//Reason: changed $tCASE_START_TAG instantiation to use 4D resource
//Modified by: Cyril Harnisch, Syncor Systems, Inc., 5/17/99
//Reason: changed $tCASE_END_TAG instantiation to use 4D resource
//******************************************************************************
C_BOOLEAN:C305($bGo; $bDone)
C_LONGINT:C283($iStartPos; $iStopPos; $lcharacterToParse)
C_TEXT:C284($tCASE_START_TAG; $tOPEN_PAREN_TAG; $tCASE_END_TAG)
C_TEXT:C284($tCaseDesc)
C_LONGINT:C283($iSize)
C_TEXT:C284(<>tSDA_Scrap_L)
C_TEXT:C284(<>tSDA_StackVal_L)
ARRAY TEXT:C222(<>atSDA_CaseDesc; 0)
ARRAY TEXT:C222(<>SDA_ma_Stack_L; 0)

SDA_util_PostSelectAll
$bGo:=SDA_ClipboardOps(<>SDA_COPY; -><>tSDA_Scrap)

If ($bGo)  //if able to successfully copy method text
	SDA_util_PostKey(Up arrow key:K12:18; 0)  //unselect the text
	$tCASE_START_TAG:=Get indexed string:C510(42; 6)+" ("  //Set up a local named Constant to find the start of a case statement
	// and use the 4D resource to ensure compatibility with non-US versions of 4D
	$tCASE_END_TAG:=Get indexed string:C510(42; 15)  //")"
	$tOPEN_PAREN_TAG:=Get indexed string:C510(42; 14)  //"("
	
	//the whole procedure is now in the scrap variable
	//loop through looking for the start of a case
	//when each start is found, look for the closing parentheses after the start
	//insert each found occurrence into the <>atSDA_CaseDesc array
	//then reduce the scrap variable to the remaining text after the found case
	Repeat   //loop for each line in method
		$iStartPos:=Position:C15($tCASE_START_TAG; <>tSDA_Scrap)
		
		If ($iStartPos#0)  //if a case start tag found
			<>tSDA_Scrap:=Substring:C12(<>tSDA_Scrap; $iStartPos)
			$lcharacterToParse:=4  //start after the 3-character case argument start tag
			
			Repeat   //loop for each character in case conditional line
				
				Case of   //different characters in string to parse
						
					: (<>tSDA_Scrap[[$lcharacterToParse]]=$tOPEN_PAREN_TAG)  //if we found an open parenthesis
						<>tSDA_StackVal_L:=$tOPEN_PAREN_TAG
						SDA_ma_Push(-><>tSDA_StackVal_L; -><>SDA_ma_Stack_L)  //put it on the stack
						$bDone:=False:C215  //don't finish looping yet
						
					: (<>tSDA_Scrap[[$lcharacterToParse]]=$tCASE_END_TAG)  //if we found a closing parenthesis
						
						If (Size of array:C274(<>SDA_ma_Stack_L)>0)  //if there is something on the stack            
							SDA_ma_Pop(-><>tSDA_StackVal_L; -><>SDA_ma_Stack_L)  //take it off the stack
							$bDone:=False:C215  //don't finish looping yet
							
						Else   //nothing on the stack
							//this must be the case conditional closing tag
							$bDone:=True:C214  //finish looping
						End if   //            If (Size of array(<>SDA_ma_Stack_L)>0)  `if there is something on the
						
					Else   //no tag found
						$bDone:=False:C215  //don't finish looping yet
				End case   //        Case of   `different characters in string to parse
				
				If ($bDone)  //if we are finished looping
					$iStopPos:=$lcharacterToParse
					ARRAY TEXT:C222(<>SDA_ma_Stack_L; 0)  //done with array, clear memory
					
				Else   //not finished looping
					
					If ($lcharacterToParse>=<>SDA_MAX_LIST_CHARS)  //if next increment will put us out of bounds
						$bDone:=True:C214  //finish looping
						$iStopPos:=$lcharacterToParse
						ARRAY TEXT:C222(<>SDA_ma_Stack_L; 0)  //done with array, clear memory
						
					Else   //increment OK
						$lcharacterToParse:=$lcharacterToParse+1
					End if   //          If ($lcharacterToParse>=<>SDA_MAX_LIST_CHARS)  `if next increment will 
					
				End if   //        If ($bDone)  `if we are finished looping
				
			Until ($bDone)  //      Repeat   `loop for each character in case conditional line
			
			If ($iStopPos<=<>SDA_MAX_LIST_CHARS)  //if a case stop tag found before the list length limit
				$tCaseDesc:=Substring:C12(<>tSDA_Scrap; 1; $iStopPos)
				
			Else   //no case stop tag found before the list length limit
				//the item is too big to fit in popup
				$tCaseDesc:=Substring:C12(<>tSDA_Scrap; 1; <>SDA_MAX_LIST_CHARS)
			End if   //      If ($iStopPos<=<>SDA_MAX_LIST_CHARS)  `if a case stop tag found before the 
			
			$iSize:=Size of array:C274(<>atSDA_CaseDesc)+1
			INSERT IN ARRAY:C227(<>atSDA_CaseDesc; $iSize)
			<>atSDA_CaseDesc{$iSize}:=$tCaseDesc
			<>tSDA_Scrap:=Substring:C12(<>tSDA_Scrap; $iStopPos+1)
		End if   //    If ($iStartPos # 0)  `if a case start tag found
		
	Until ($iStartPos=0)  //  Repeat   `loop for each line in method
	
	If (Size of array:C274(<>atSDA_CaseDesc)=0)
		INSERT IN ARRAY:C227(<>atSDA_CaseDesc; 1)
		<>atSDA_CaseDesc{1}:=<>SDA_MSG_NO_CASE  //put in the  message that says there are no case stmts
	End if   //  If (Size of array(<>atSDA_CaseDesc)=0)
	
Else   //could not copy method text
	SDA_util_BugAlert(<>SDA_METHOD_COPY_ERROR; "SDA_CaseBuildList ")
End if   //If ($bGo)  `if able to successfully copy method text

//-----Clean up memory-----
<>tSDA_Scrap:=""
