//%attributes = {}
//******************************************************************************
//Method: SDA_PaletteOpen
//
//Written by  Tod Gentille on 10/1/98
//
//Purpose: Open the floating palette used to communicate to the design env.
//
//Copyright 1997 Syncor Systems, Inc.
//
//******************************************************************************
C_BOOLEAN:C305($bFound)
C_LONGINT:C283($lxStart; $lyStart)
ARRAY LONGINT:C221(<>alPaletteCoords_L; 4)  //local in scope but we pass a pointer to it

$bFound:=SDA_PaletteLoadPosition(-><>alPaletteCoords_L)

//-------------------------------------------------------------------------------
//You can also try window type 1984, it will give you a resize box on the Mac
//but if the palette is horizontal it minimizes to a much wider bar than the SDA m
//however, then you can change SDA_ClosePalette to really close the window
//instead of having to option click the close box
<>lSDA_PaletteWinRef:=Open window:C153(0; 0; 1; 1; -(720); ""; "SDA_ClosePalette")
// v67: Palette window

If ($bFound)  //if the palette last position document was found
	//figure out if it is horiz or vertical
	//this test will work except when the user quit while the palette was minimized
	//the minimized coords are the same for horiz or vert so there is not way to tell
	//in this case the palette will think it is in horiz, if it was in vertical the to
	//will have to be hit twice to toggle to horizontal the first time.  
	If ((<>alPaletteCoords_L{3}-<>alPaletteCoords_L{1})>(<>alPaletteCoords_L{4}-<>alPaletteCoords_L{2}))  //if it is wider than it is tall is but be horizontal
		<>bSDA_HorizontalToolbar:=True:C214
	Else 
		<>bSDA_HorizontalToolbar:=False:C215
	End if 
	If ((<>alPaletteCoords_L{1}<=1) | (<>alPaletteCoords_L{2}<=80) | (<>alPaletteCoords_L{1}>=Screen width:C187) | (<>alPaletteCoords_L{2}>=Screen height:C188))
		$lxStart:=<>alPaletteCoords_L{1}-20
		$lyStart:=<>alPaletteCoords_L{2}-200
		<>alPaletteCoords_L{1}:=<>alPaletteCoords_L{1}-$lxStart
		<>alPaletteCoords_L{3}:=<>alPaletteCoords_L{3}-$lxStart
		<>alPaletteCoords_L{2}:=<>alPaletteCoords_L{2}-$lyStart
		<>alPaletteCoords_L{4}:=<>alPaletteCoords_L{4}-$lyStart
	End if 
	SET WINDOW RECT:C444(<>alPaletteCoords_L{1}; <>alPaletteCoords_L{2}; <>alPaletteCoords_L{3}; <>alPaletteCoords_L{4}; <>lSDA_PaletteWinRef)
	//Now call resize so that the IP vars for height and width get set and also
	//in case the palette was minimized when user quit this will make it show up 
	//normal size again.  
	SDA_PaletteWinAdjust(-><>alPaletteCoords_L{1}; -><>alPaletteCoords_L{2})
	SDA_PaletteResize(<>alPaletteCoords_L{1}; <>alPaletteCoords_L{2})
	
Else   //palette last position document not found
	//if we didn't get it from the blob just set it here
	//Initialize some constant values - these can all be changed by the end user
	$lyStart:=200  //this is beneath the toolbar, if it is not used this can be 30
	$lxStart:=20  //you can change this if you wan the left edge of the palette somewhere else
	SDA_PaletteResize($lxStart; $lyStart)
End if 

DIALOG:C40("SDA_Palette")
