//%attributes = {}
//******************************************************************************
//
//Method: SDA_ReplaceOps
//
//Written by  Tod Gentille on 10/13/97
//
//Purpose: Put up a replace dialog and replace all occurences of the found string
//in either the current selection or the entire method
//
//Modified by Tod Gentille on 4/20/98 SDA Version 2.0
//Uses the status that is now returned from SDA_ClipboardOps to check 
//for operations completing before continuing. Displays error alert if any problem
//Copyright 1998 Syncor Systems, Inc.
//
//******************************************************************************

//---------- Declare the IP vars used on the dialog ----------  
C_TEXT:C284(<>tSDA_ReplaceType)  //an information string in the dialog
C_TEXT:C284(<>tSDA_Find; <>tSDA_Replace)  //the layout vars that hold the find and replace user entries
C_LONGINT:C283(<>lbSDA_ReplaceAll; <>lbSDA_Cancel)  //buttons on the dialog


C_POINTER:C301($1; $pPopupMenu)
C_LONGINT:C283($iSelItem)
C_TEXT:C284($tChoice)

C_BOOLEAN:C305($bGo)
_O_C_STRING:C293(79; $s79_WindowTitle)  //++Replace window
$s79_WindowTitle:=<>SDA_REPLACE_WIN_TITLE
//<>tSDA_Find:=""
//<>tSDA_Replace:=""
$pPopupMenu:=$1

$iSelItem:=$pPopupMenu->  //Find out which item was selected in the popup
$tChoice:=$pPopupMenu->{$iSelItem}  //Get the selected item
If ($iSelItem>0)
	
	$bGo:=True:C214
	Case of   //set up the ip var for the display dialog
			
		: ($tChoice="Replace In Method")
			<>tSDA_ReplaceType:=<>SDA_REPLACE_ALL
			
		: ($tChoice="Replace In Selection")
			<>tSDA_ReplaceType:=<>SDA_REPLACE_SELECTION
			
		: ($tChoice="Replace In All Open Windows")
			<>tSDA_ReplaceType:=<>SDA_REPLACE_OPEN_WIN
			
		: ($tChoice="Replace In N Next Methods")
			<>tSDA_ReplaceType:=<>SDA_REPLACE_N_METHODS
			
		: ($tChoice="Find Highlighted Text")
			SDA_ClipboardOps(<>SDA_COPY; -><>tSDA_Scrap; False:C215)
			SDA_util_FindPostSequence(-><>tSDA_Scrap)
			$bGo:=False:C215  //keep the find replace dialog from coming up
			
		Else 
			$bGo:=False:C215
			SDA_util_BugAlert(<>SDA_UNEXPECTED_PARAM; " Method: SDA_ReplaceOps "; $tChoice)
	End case   //  Case of 
	
Else 
	$bGo:=False:C215
End if   //If ($iSelItem>0)

If ($bGo)
	Open window:C153(20; 110; 390; 275; Alternate dialog box:K34:5+Has window title:K34:11; $s79_WindowTitle)
	DIALOG:C40("SDA_Replace.dlg")
	CLOSE WINDOW:C154
	
	If (OK=1)
		
		Case of 
				
			: ($tChoice="Replace In Method")
				If (SDA_util_PostSelectAll)
					SDA_Replace(<>tSDA_Find; <>tSDA_Replace)  //to prevent coupling directly to the IP vars pass them in
				Else 
					//not much we can do if the select all command fails
					BEEP:C151
				End if 
				
			: ($tChoice="Replace In Selection")
				SDA_Replace(<>tSDA_Find; <>tSDA_Replace)
				
			: ($tChoice="Replace In All Open Windows")
				SDA_ReplaceOpenWindows(<>tSDA_Find; <>tSDA_Replace)
				
			: ($tChoice="Replace In N Next Methods")
				SDA_Replace_N_Methods(<>tSDA_Find; <>tSDA_Replace)
				
			Else 
				$bGo:=False:C215
				SDA_util_BugAlert(<>SDA_UNEXPECTED_PARAM; " Method: SDA_ReplaceOps "; $tChoice)
		End case   //  Case of 
		
		
		
		
		
	End if   //Check that user hit OK from dialog`  If (OK=1)
	//
End if   //If ($bGo)
