//%attributes = {}
//******************************************************************************
//Method: SDA_ma_MethodAnalysis(controlCounter;maxDepth;{pTextArray})
//Written by  Tod Gentille on 4/21/98
//
//Purpose: Analyse the method for control structures and nesting levels and 
//if passed a third array also Add comments to end of all control structures 
//
//parameters - see below
//Copyright 1998 Syncor Systems, Inc.
//Portions copyright 1997 Richard Ray - used with permission
//Modified by Cyril Harnisch on 2/3/99
//Reason: Added comments to code; added parameter 4
//Modified by Tod Gentille 6/5/2000 turned into function
//returns false if control structs are out of balance
//also displays error message
//******************************************************************************
C_POINTER:C301($1; $plControlCounter)
C_POINTER:C301($2; $plMaxDepth)
C_POINTER:C301($3; $patDestLines)
C_BOOLEAN:C305($4; $bForcedCommentRplc)
C_BOOLEAN:C305($bAddComments)
C_LONGINT:C283($iArraySize; $i; $iDestIdx; $lCommentCharPos; $lSizeOfArray)
_O_C_STRING:C293(1; $CR)
C_TEXT:C284($tOneLineOfSource)
C_BOOLEAN:C305($bOutOfBalanceErr)
C_TEXT:C284($tOutOfBalanceLine)
C_BOOLEAN:C305($0)

ARRAY TEXT:C222(<>atSDA_ScrapDest_L; 0)

$plControlCounter:=$1
$plMaxDepth:=$2
$plControlCounter->:=0
$plMaxDepth->:=0

If (Count parameters:C259>3)  //if at least 4 parameters
	$patDestLines:=$3
	$bForcedCommentRplc:=$4
	$bAddComments:=True:C214  //indicate that we want to add comments to output array
	
Else   //less than 4 parameters
	$bAddComments:=False:C215
	$patDestLines:=-><>atSDA_ScrapDest_L  //this array should never get used, it just eliminates having
	//to check the paramter count in various places in this method  
End if   //If (Count parameters>3)  `if at least 4 parameters
//
//All variables that end with _L could be locals except we need to pass pointers
//to them. If a future version of 4D ever changes this, the naming convention 
//will make it easy to find and replace the globals with locals.
//The programmer can also rely that these vars are not used directly outside the s
//of this method but only when passed as parameters

ARRAY TEXT:C222(<>atSDA_SourceLine_L; 0)
ARRAY TEXT:C222(<>SDA_ma_Stack_L; 0)
C_TEXT:C284(<>tSDA_Scrap_L)
C_TEXT:C284(<>tSDA_StackVal_L)

<>tSDA_StackVal_L:=""
//
//----- Define the local constants -----
$CR:=Char:C90(Carriage return:K15:38)

//---------------------------------Method: SDA_ma_MethodAnalysis------------------
//Get whatever is highlighted
SDA_ClipboardOps(<>SDA_COPY; -><>tSDA_Scrap_L)

If (<>tSDA_Scrap_L="")  //don't do anything if the user didn't highlight something or the method is empty
	BEEP:C151
	ARRAY TEXT:C222(<>atSDA_DestLine_L; 0)  //Clear this array so nothing is copied to method
	// this is what parameter 3 points to
	
Else   //there is something to process
	//Put each line of the method into an array element
	SDA_util_Parse(<>tSDA_Scrap_L; -><>atSDA_SourceLine_L)
	
	For ($i; 1; Size of array:C274(<>atSDA_SourceLine_L))
		<>atSDA_SourceLine_L{$i}:=Replace string:C233(<>atSDA_SourceLine_L{$i}; $CR; "")
	End for   //  For ($i;1;Size of array(<>atSDA_SourceLine_L))
	//
	$iArraySize:=Size of array:C274(<>atSDA_SourceLine_L)
	ARRAY TEXT:C222($patDestLines->; $iArraysize)
	$iDestIdx:=$iArraySize
	
	$bOutOfBalanceErr:=False:C215
	$tOutOfBalanceLine:=""
	For ($i; 1; $iArraySize)
		$tOneLineOfSource:=<>atSDA_SourceLine_L{$i}
		
		If (SDA_ma_IsConstructKeyword($tOneLineOfSource))  //then this line is a candidate
			
			Case of 
					
				: (SDA_ma_IsControlOpen($tOneLineOfSource))  //if the beginning of a control structure
					<>tSDA_StackVal_L:=$tOneLineOfSource
					SDA_ma_Push(-><>tSDA_StackVal_L; -><>SDA_ma_Stack_L; $plControlCounter)
					
					If ($bAddComments)  //if we are filling a comments array
						$patDestLines->{$i}:=$tOneLineOfSource+$CR
					End if   //          If ($bAddComments)  `if we are filling a comments array
					
				: (SDA_ma_IsControlClose($tOneLineOfSource))  //if the end of a control structure
					<>tSDA_StackVal_L:=""
					If (SDA_ma_Pop(-><>tSDA_StackVal_L; -><>SDA_ma_Stack_L))
						
						If ($bAddComments)  //if we are filling a comments array
							$lCommentCharPos:=Position:C15("`"; $tOneLineOfSource)
							
							If ($lCommentCharPos=0)  //if no comment
								$patDestLines->{$i}:=$tOneLineOfSource+"`"+<>tSDA_StackVal_L+$CR  //add comment
								
							Else   //comment exists
								
								If ($bForcedCommentRplc)  //if forced replacement has been selected
									// delete the old comment from the source and append the new comment       
									$tOneLineOfSource:=Delete string:C232($tOneLineOfSource; $lCommentCharPos; Length:C16($tOneLineOfSource))
									$patDestLines->{$i}:=$tOneLineOfSource+"`"+<>tSDA_StackVal_L+$CR
									
								Else   //no forced replacement
									$patDestLines->{$i}:=$tOneLineOfSource+$CR  //do not add another comment
								End if   //                If ($bForcedCommentRplc)  `if forced replacement has been select
								
							End if   //              If ($lCommentCharPos=0)  `if no comment
							
						End if   //            If ($bAddComments)  `if we are filling a comments array
						
					Else 
						$bOutOfBalanceErr:=True:C214
						$tOutOfBalanceLine:=$tOneLineOfSource
					End if   //          If (SDA_ma_Pop (-><>tSDA_StackVal_L;-><>SDA_ma_Stack_L))
					
					//
				Else   //for case statement
					
					If ($bAddComments)  //if we are filling a comments array
						$patDestLines->{$i}:=$tOneLineOfSource+$CR
					End if   //          If ($bAddComments)  `if we are filling a comments array
					
			End case   //      Case of 
			
		Else   //------------------------line is not a candidate --------------------------------
			
			$patDestLines->{$i}:=$tOneLineOfSource+$CR
		End if   //    If (SDA_ma_IsConstructKeyword ($tOneLineOfSource))  `then this line is a can
		//------------------------------------------------------------------------------- 
		
		$lSizeOfArray:=Size of array:C274(<>SDA_ma_Stack_L)
		
		If ($lSizeOfArray>$plMaxDepth->)
			$plMaxDepth->:=$lSizeOfArray
		End if   //    If ($lSizeOfArray>$plMaxDepth->)
		
	End for   //  For ($i;1;$iArraySize)
	
	If (Size of array:C274(<>SDA_ma_Stack_L)>0)
		$bOutOfBalanceErr:=True:C214
	End if   //  If (Size of array(<>SDA_ma_Stack_L)>0)
	
	If ($bOutOfBalanceErr)
		$0:=False:C215
		If ($tOutOfBalanceLine="")
			_info_ ALERT("Your open and close control structures are out of balance."+$CR+"Please fix and try again.")
		Else 
			_info_ ALERT("Your open and close control structures are out of balance."+$CR+"Processing Line "+$tOutOfBalanceLine+$CR+"Please fix and try again.")
		End if   // If ($tOutOfBalanceLine="")
	Else 
		$0:=True:C214
	End if   //  If ($bOutOfBalanceErr)
	
	
End if   //If (<>tSDA_Scrap_L="")  `don't do anything if the user didn't highlight something

//

//Clean up memory
<>tSDA_Scrap_L:=""
<>tSDA_StackVal_L:=""
ARRAY TEXT:C222(<>atSDA_SourceLine_L; 0)
ARRAY TEXT:C222(<>SDA_ma_Stack_L; 0)
