//%attributes = {}
//******************************************************************************
//Method: SDA_util_CloseWindowWait
//Written by  Tod Gentille on 9/24/1998
//
//Purpose: Post a close window command key and wait for the window to close
//checks for the window to close by getting the frontmost window name first
//and then waits for the frontmost window name to change
//
//Copyright 1998 Syncor Systems, Inc.
//
//******************************************************************************
C_LONGINT:C283($iCount)
C_TEXT:C284($tWinTitle)

$tWinTitle:=Get window title:C450(Frontmost window:C447)
SDA_util_PostKey(<>SDA_ASCII_CLOSE_WINDOW_KEY; Command key mask:K16:1; False:C215)
//Wait until the title of the frontmost window changes          
//that means it has closed

$iCount:=1

While (($tWinTitle=Get window title:C450(Frontmost window:C447)) & ($iCount<<>SDA_MAX_WAIT_LOOP))
	$iCount:=$iCount+1
	DELAY PROCESS:C323(Current process:C322; 1)
End while 
//return true if the window actually closed (ie orig win name # current win name)
$0:=Not:C34($tWinTitle=Get window title:C450(Frontmost window:C447))
