//%attributes = {}
//_prli_SetBrkText(AreaRef;BreakLev;ColNum;BrkTxt;NumColToOverflow;Alignment)

//Part of the PrintTwist(tm) component by Business Brothers, Inc.
//Written by Tony Ringsmuth

//See Also: _prli_Util_PrintBreaks
//--------------------------------------------------------------------------------
//FUNCTION


//--------------------------------------------------------------------------------
//PARAMETERS
//$1: Longint: PrintAreaRef
//$2: Longint: Break level (starting at zero)
//$3: Longint: Column number
//$4: Text: BrkText:  Besides normal text, you can include keywords:
//         \Sum, \Average, \Minimum, \Maximum, \Count, \BreakValue, \Function
//         PT Extras (above & beyond PrintList):   \FirstValue, \LastValue
//$5: Longint: Number of coluns to overflow
//$6: Longint: Allignment; 0 = Default, 1 = Left, 2 = Center, 3 = Right

//--------------------------------------------------------------------------------
//REVISION HISTORY

//--------------------------------------------------------------------------------
//EXAMPLE:


//--------------------------------------------------------------------------------
C_LONGINT:C283($1; $_prli_iAreaRef; $2; $_prli_BrkLev; $3; $_prli_ColNum; $5; $_prli_Overflow; $6)
C_LONGINT:C283($_prli_iFindArea; $_prli_iFindlevCol)
C_TEXT:C284($4; $_prli_BrkText)
C_BOOLEAN:C305(_prli_bRunAsWrapper)

$_prli_iAreaRef:=$1
$_prli_BrkLev:=$2
$_prli_ColNum:=$3

$_prli_BrkText:=""
If (Count parameters:C259>3)
	$_prli_BrkText:=$4
End if 

$_prli_Overflow:=0
If (Count parameters:C259>4)
	$_prli_Overflow:=$5
End if 

$_prli_iFindArea:=_prli_Util_FindAreaRef($_prli_iAreaRef; Current method name:C684)
If ($_prli_iFindArea>-1)
	$_prli_iFindlevCol:=_prli_Util_InsertBreakElement($_prli_iFindArea; $_prli_BrkLev; $_prli_ColNum)
	
	_prli_aBrk_Text{$_prli_iFindArea}{$_prli_iFindlevCol}:=$_prli_BrkText
	_prli_aBrk_OverflowCols{$_prli_iFindArea}{$_prli_iFindlevCol}:=$_prli_Overflow
	If (Count parameters:C259>5)
		_prli_aBrk_Justify{$_prli_iFindArea}{$_prli_iFindlevCol}:=$6
	Else 
		_prli_aBrk_Justify{$_prli_iFindArea}{$_prli_iFindlevCol}:=0
	End if 
	
End if 

If (_prli_bRunAsWrapper)
	C_TEXT:C284($_prli_Execute)
	$_prli_Execute:="PL_SetBrkText ("+_prli_Util_AreaRefString($_prli_iAreaRef)+";"
	
	If (Count parameters:C259>1)
		$_prli_Execute:=$_prli_Execute+String:C10($2)+";"
	End if 
	If (Count parameters:C259>2)
		$_prli_Execute:=$_prli_Execute+String:C10($3)+";"
	End if 
	If (Count parameters:C259>3)
		$_prli_Execute:=$_prli_Execute+Char:C90(34)+$4+Char:C90(34)+";"
	End if 
	If (Count parameters:C259>4)
		$_prli_Execute:=$_prli_Execute+String:C10($5)+";"
	End if 
	If (Count parameters:C259>5)
		$_prli_Execute:=$_prli_Execute+String:C10($6)+";"
	End if 
	
	$_prli_Execute:=Substring:C12($_prli_Execute; 1; Length:C16($_prli_Execute)-1)+")"
	_prli_Util_QueuePLCode($_prli_iAreaRef; $_prli_Execute)
End if 

//
