//%attributes = {}
// Method: ldcap_PhaseTimeMultiplier
// 2004.10.19-11:09:07 / Pasi Mankinen
// © Copyright 2004 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
C_LONGINT:C283($1; $ld_lIndex)
C_REAL:C285($0; $ld_rPhaseTimeMultiplier; $ld_rLeadTimeMultiplier; $ld_rLoadEfficiencyMultiplier; $ld_rLoadMultiplier)
C_TEXT:C284($3; $ld_tLoadGroup)

$ld_lIndex:=$1
$ld_rLeadTimeMultiplier:=$2
$ld_tLoadGroup:=$3

Case of 
	: (ldcap_arMaxWorkMultiplier{$ld_lIndex}=0)
		$ld_rPhaseTimeMultiplier:=ldcap_arMultiplier{$ld_lIndex}
	: (ldcap_arMultiplier{$ld_lIndex}<ldcap_arMaxWorkMultiplier{$ld_lIndex})
		$ld_rPhaseTimeMultiplier:=ldcap_arMultiplier{$ld_lIndex}
	Else 
		$ld_rPhaseTimeMultiplier:=ldcap_arMaxWorkMultiplier{$ld_lIndex}
End case 

If (($ld_rPhaseTimeMultiplier>0) & (ld_lWorkMoveExtra=kTrue))  //PM: 2009-02-10
	Case of 
		: (ldcap_tExtraTimeCapName#"")  //set at: ldcap_ARR_LOAD_SAVE
			// IDLE
		: (<>ld_rExtraTimeMultiplierStatic>0)
			$ld_rPhaseTimeMultiplier:=<>ld_rExtraTimeMultiplierStatic
		: ((<>ld_rExtraTimeMultiplierMax>0) & ($ld_rPhaseTimeMultiplier><>ld_rExtraTimeMultiplierMax))
			$ld_rPhaseTimeMultiplier:=<>ld_rExtraTimeMultiplierMax
		: ((<>ld_rExtraTimeMultiplierMin>0) & ($ld_rPhaseTimeMultiplier<<>ld_rExtraTimeMultiplierMin))
			$ld_rPhaseTimeMultiplier:=<>ld_rExtraTimeMultiplierMin
		Else 
			IDLE:C311
	End case 
End if 


If ((<>ld_lPhaseLoadMultiplierUse=kTrue) & (ld_lWorkMoveExtra=kFalse))
	//COMPILER_ld_ip  
	
	//lead time multiplier
	If (($ld_rLeadTimeMultiplier=0) & (<>ld_lLgEfficiencyMultiplierUse=kTrue))
		$ld_rLeadTimeMultiplier:=ld_wlg_LoadMultiplierGet($ld_tLoadGroup)
	End if 
	
	If ($ld_rLeadTimeMultiplier<=0)  //= use directly <>ld_rLeadTimeMultiplier
		$ld_rLeadTimeMultiplier:=<>ld_rLeadTimeMultiplier
	End if 
	
	//efficiency multiplier
	$ld_rLoadEfficiencyMultiplier:=0
	If (<>ld_lLgEfficiencyMultiplierUse=kTrue)  //get multiplier from load group
		$ld_rLoadEfficiencyMultiplier:=ld_wlg_LoadEfficiencyMultipGet($ld_tLoadGroup)
		//we could cache multiplier if 
		If ($ld_rLoadEfficiencyMultiplier<=0)
			$ld_rLoadEfficiencyMultiplier:=<>ld_rLoadEfficiencyMultiplier
		End if 
	Else 
		$ld_rLoadEfficiencyMultiplier:=<>ld_rLoadEfficiencyMultiplier
	End if 
	
	$ld_rLoadMultiplier:=$ld_rLeadTimeMultiplier*$ld_rLoadEfficiencyMultiplier
	If (($ld_rLoadMultiplier>0) & ($ld_rLoadMultiplier<$ld_rPhaseTimeMultiplier))  //$ld_rPhaseTimeMultiplier here is capacity multiplier
		$ld_rPhaseTimeMultiplier:=$ld_rLoadMultiplier
	End if 
	
End if 

$0:=$ld_rPhaseTimeMultiplier
