//%attributes = {}
// Method: pr_AVERAGE_PRICE_RECALC_PRS
// 2007.04.11-18:56:47 / Arto Kokkila
// © Copyright 2007 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
C_REAL:C285($pr_rPrevAvgPrice; $pr_rPrevStockBalance; $pr_rPurchasePrice; $pr_rAmount; $pr_rNewAvgPrice; $pr_rAvgPriceOld)
C_LONGINT:C283($pr_lIndex; $pr_lSelSize; $pr_lStIndex; $pr_lStSelSize; $pr_lCancelled; $pr_lAvgPriceStartValueFld; $pr_lStockBalanceStartValueFld)
C_TEXT:C284($pr_tName; $pr_tInfoDateTimeTxt; $pr_tInfoTxt)
$pr_tName:=_lang Current("Average price repair")  //+": "+
COMPILER_pr
COMPILER_st

$pr_lAvgPriceStartValueFld:=0
If (<>pr_tAvgPriceStartValueFld#"")
	$pr_lAvgPriceStartValueFld:=_var ConstantNameToLong(<>pr_tAvgPriceStartValueFld)
End if 
$pr_lStockBalanceStartValueFld:=0
If (<>pr_tStockBalanceStartValueFld#"")
	$pr_lStockBalanceStartValueFld:=_var ConstantNameToLong(<>pr_tStockBalanceStartValueFld)
End if 

//_sel ALL_RECS (pr_kTbl )
_tbl WRITE_STATE(pr_kTbl; kTrue)
_tbl WRITE_STATE(st_kTbl; kTrue)
_trans_ START

_err FIX("Replace ORDER BY -command ("+Current method name:C684+")")

$pr_lCancelled:=kFalse
$pr_tInfoTxt:=_lang Current("Average price change was made")+": "
$pr_tInfoDateTimeTxt:=" ("+_date CurrentDateTimeToString+"/"+Current user:C182+")"
$pr_lSelSize:=_sel RecsInSel(pr_kTbl)
_thm OPEN($pr_lSelSize; _lang Current("Recalculating stock event average prices")+"..."; $pr_tName; True:C214)
_sel REC_FIRST(pr_kTbl)
For ($pr_lIndex; 1; $pr_lSelSize)
	_thm UPDATE($pr_lIndex)
	If (_thm Cancelled=kTrue)
		$pr_lIndex:=$pr_lSelSize
		$pr_lCancelled:=kTrue
		
	Else 
		_sel RELATE_MANY(pr_kProduct_ID; st_kProduct_id)
		ORDER BY:C49([Stock_Event:8]; [Stock_Event:8]Date_:5; >; [Stock_Event:8]Time_:6; >; [Stock_Event:8]Stock_Event_ID:11; >)
		_sel REC_FIRST(st_kTbl)
		$pr_lStSelSize:=_sel RecsInSel(st_kTbl)
		$pr_rPrevAvgPrice:=0
		If ($pr_lAvgPriceStartValueFld#0)
			$pr_rPrevAvgPrice:=_fld ValueReal($pr_lAvgPriceStartValueFld)
		End if 
		$pr_rPrevStockBalance:=0
		If ($pr_lStockBalanceStartValueFld#0)
			$pr_rPrevStockBalance:=_fld ValueReal($pr_lStockBalanceStartValueFld)
		End if 
		_sel REC_FIRST(st_kTbl)
		For ($pr_lStIndex; 1; $pr_lStSelSize)
			$pr_rPurchasePrice:=_fld ValueReal(st_kPurchase_Price__unit)
			Case of 
				: ($pr_rPrevAvgPrice<=0)
					$pr_rNewAvgPrice:=$pr_rPurchasePrice
				: ($pr_rPrevStockBalance<=0)
					$pr_rNewAvgPrice:=$pr_rPurchasePrice
				: (_fld ValueStr(st_kType_)=<>st_tTypeAddition)
					$pr_rAmount:=_fld ValueReal(st_kAmount__unit)
					$pr_rNewAvgPrice:=st_ AveragePriceCalculate($pr_rPrevStockBalance; $pr_rPrevAvgPrice; $pr_rAmount; $pr_rPurchasePrice)
				Else 
					$pr_rNewAvgPrice:=$pr_rPrevAvgPrice
			End case 
			$pr_rAvgPriceOld:=_fld ValueReal(st_kAverage_Price)
			//Save avg price to stock event
			If ($pr_rNewAvgPrice#$pr_rAvgPriceOld)
				_rec LOCKED_WAIT(st_kTbl; kTrue)
				If (OK#1)
					_txt:=_fld ValueStr(st_kStock_Event_ID)
					_err MESSAGE(_lang Current("Stock event was locked")+": "+_txt; $pr_tInfoTxt; kFalse)
				Else 
					_fld VALUE_REAL_SET(kSet; st_kAverage_Price; $pr_rNewAvgPrice)
					$pr_tInfo:=_fld ValueStr(st_kInfo)
					$pr_tInfo:=$pr_tInfo+ksCR+ksCR+$pr_tInfoTxt+String:C10($pr_rAvgPriceOld)+" -> "+String:C10($pr_rNewAvgPrice)+$pr_tInfoDateTimeTxt
					_fld VALUE_STR_SET(kSet; st_kInfo; $pr_tInfo)
					_rec SAVE(st_kTbl)
				End if 
			End if 
			//Save avg price to stock event        
			$pr_rPrevAvgPrice:=$pr_rNewAvgPrice
			$pr_rPrevStockBalance:=_fld ValueReal(st_kStock_Balance)
			_sel REC_NEXT(st_kTbl)
		End for 
		//
		//Save avg price to product
		_rec LOCKED_WAIT(pr_kTbl; kTrue)
		If (OK#1)
			_txt:=_fld ValueStr(pr_kProduct_ID)
			_err MESSAGE(_lang Current("Product was locked")+": "+_txt; $pr_tName; kFalse)
		Else 
			$pr_rAvgPriceOld:=_fld ValueReal(pr_kAverage_Price)
			_fld VALUE_REAL_SET(kSet; pr_kAverage_Price; $pr_rNewAvgPrice)
			$pr_tInfo:=_fld ValueStr(pr_kInfo)
			$pr_tInfo:=$pr_tInfoTxt+String:C10($pr_rAvgPriceOld)+" -> "+String:C10($pr_rNewAvgPrice)+$pr_tInfoDateTimeTxt+ksCR+$pr_tInfo
			_fld VALUE_STR_SET(kSet; pr_kInfo; $pr_tInfo)
			_rec SAVE(pr_kTbl)
		End if 
		// Save avg price to product      
		//
	End if 
	_sel REC_NEXT(pr_kTbl)
End for 
_thm CLOSE
If ($pr_lCancelled=kFalse)
	_trans_ VALIDATE
Else 
	_trans_ CANCEL
	_err MESSAGE(_lang Current("Operation cancelled, no date changes was made"); $pr_tName; kFalse)
End if 
_tbl WRITE_STATE(pr_kTbl; kPrevious)
_tbl WRITE_STATE(st_kTbl; kPrevious)
