//%attributes = {}
// Method: pr_FIRST_STOCK_EVENT_CHECK
// 2007.04.23-15:34:05 / Arto Kokkila
// © Copyright 2007 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
C_LONGINT:C283($1; $pr_lSaveDateToProduct; $pr_lContinue)
C_LONGINT:C283($pr_lIndex; $pr_lSelSize)
C_TEXT:C284($pr_tProduct; $pr_tPrevProduct; $pr_tMessageHdr; $pr_tInfoTxt)
C_REAL:C285($pr_rStockBalance; $pr_rAmount)
$pr_lSaveDateToProduct:=$1

//0=only check first event stock balance
//1=check and save first event date to product
//2=only get first events
$pr_lContinue:=kNo
Case of 
	: ($pr_lSaveDateToProduct=0)
		$pr_lContinue:=_info_ Confirm(_lang Current("Check first stock event stock balance?"))
	: ($pr_lSaveDateToProduct=1)
		$pr_lContinue:=_info_ Confirm(_lang Current("Check first stock event stock balance and save first event date to product?"))
	Else 
		$pr_lContinue:=kYes
End case 
If ($pr_lContinue=kYes)
	
	If (_el Where=_el_kInOutput)
		_fo SEL_USE(Into current selection:K19:1; "")
	End if 
	
	_tbl WRITE_STATE(pr_kTbl; kTrue)
	_sel RELATE MANY SELECTION(st_kProduct_id)
	ORDER BY:C49([Stock_Event:8]; [Stock_Event:8]Product_id:1; >; [Stock_Event:8]Date_:5; >; [Stock_Event:8]Time_:6; >; [Stock_Event:8]Stock_Event_ID:11; >)
	
	$pr_tMessageHdr:=_lang Current("Check first stock event")
	$pr_tInfoTxt:=_lang Current("Product first stock event stock balance is wrong")+": "+_tbl Name(pr_kTbl)+ksSpace
	$pr_lSelSize:=_sel RecsInSel(st_kTbl)
	_set EMPTY_CREATE(st_kTbl; "<>st_WrongStockBalance")
	_thm OPEN($pr_lSelSize; _lang Current("Checking first event stock balance")+"..."; $pr_tMessageHdr; True:C214)
	_sel REC_FIRST(st_kTbl)
	$pr_tPrevProduct:=""
	For ($pr_lIndex; 1; $pr_lSelSize)
		_thm UPDATE($pr_lIndex)
		If (_thm Cancelled=kTrue)
			$pr_lIndex:=$pr_lSelSize
			$pr_lCancelled:=kTrue
		Else 
			
			$pr_tProduct:=_fld ValueStr(st_kProduct_id)
			If ($pr_tProduct#$pr_tPrevProduct)  //is first event
				$pr_rStockBalance:=_fld ValueReal(st_kStock_Balance)
				$pr_rAmount:=_fld ValueReal(st_kAmount__unit)
				
				If ($pr_lSaveDateToProduct=2)
					_set ADD_TO_SET(st_kTbl; "<>st_WrongStockBalance")
				Else 
					If ($pr_rAmount#$pr_rStockBalance)
						_err MESSAGE($pr_tInfoTxt+$pr_tProduct+", "+_tbl Name(st_kTbl)+ksSpace+_fld ValueStr(st_kStock_Event_ID); $pr_tMessageHdr; kFalse)
						_set ADD_TO_SET(st_kTbl; "<>st_WrongStockBalance")
					End if 
					If ($pr_lSaveDateToProduct=1)
						_sel RELATE_ONE(pr_kProduct_ID; st_kProduct_id)
						_rec LOCKED_WAIT(pr_kTbl; kTrue)
						If (OK#1)
							_err MESSAGE(_lang Current("Record was locked")+": "+_fld ValueStr(pr_kProduct_ID); $pr_tMessageHdr; kFalse)
						Else 
							_date:=_fld ValueDate(st_kDate_)
							_fld VALUE_DATE_SET(kSet; pr_kAverage_Balance_Start_Date; _date)
							_rec SAVE(pr_kTbl)
						End if 
					End if 
				End if 
				
			End if 
			$pr_tPrevProduct:=_fld ValueStr(st_kProduct_id)
			
		End if 
		_sel REC_NEXT(st_kTbl)
	End for 
	_thm CLOSE
	_tbl WRITE_STATE(pr_kTbl; kPrevious)
	
	If (_set RecsInSet(st_kTbl; "<>st_WrongStockBalance")>0)
		_el RUN(_el_kmOutput; st_kTbl; Into set:K19:2; "<>st_WrongStockBalance"; kFalse; _el_kmOutput; 0)
	End if 
End if 
