//%attributes = {}
// Method: st_PrevValuesToProductSave
// 2007.05.04-13:48:31 / Arto Kokkila
// © Copyright 2007 Manage Applications
// Purpose: 
//
// Stock event must be current record
// ------------------------------------------------------------
C_LONGINT:C283($0; $st_lSelSize; $st_lAvgPriceStartValueFld; $st_lStockBalanceStartValueFld)
C_TEXT:C284($st_tProduct; $st_tStockEventId)
C_DATE:C307($st_dDate)
C_TIME:C306($st_hTime)
C_REAL:C285($st_rDateTime; $st_rPrevDateTime)
C_REAL:C285($st_rProductStockBalance; $st_rProductAverageBalance; $st_rProductAveragePrice; $st_rProductPurchaseAveragePrice; $st_rProductPurchAvgPriceAmou)
C_DATE:C307($st_dProductLastStockEventDate; $st_dProductAvgBalanceStartDate)
$st_tStockEventId:=_fld ValueStr(st_kStock_Event_ID)
$st_tProduct:=_fld ValueStr(st_kProduct_id)
$st_dDate:=_fld ValueDate(st_kDate_)
$st_hTime:=_fld ValueTime(st_kTime_)
$st_lSelSize:=0

_tbl WRITE_STATE(pr_kTbl; kTrue)
If ($st_tProduct#_fld ValueStr(pr_kProduct_ID))
	_sel RELATE_ONE(pr_kProduct_ID; st_kProduct_id)
End if 

$st_lSelSize:=st_PreviousStockEventGet($st_tProduct; $st_dDate; $st_hTime; $st_tStockEventId)  //changes stock event selection
If ($st_lSelSize>0)
	$st_rProductStockBalance:=_fld ValueReal(st_kStock_Balance)  //AK: 2007-05-08: 
	$st_rProductAverageBalance:=_fld ValueReal(st_kAverage_Balance)
	$st_rProductAveragePrice:=_fld ValueReal(st_kAverage_Price)
	$st_rProductPurchaseAveragePrice:=_fld ValueReal(st_kPurchase_Average_Price)
	$st_rProductPurchAvgPriceAmou:=_fld ValueReal(st_kPurch_Avg_Price_Amount)
	$st_dProductLastStockEventDate:=_fld ValueDate(st_kDate_)
Else   //$st_dAverageBalanceStartDate
	$st_rProductStockBalance:=0  //AK: 2007-05-08: 
	$st_rProductAverageBalance:=0
	$st_rProductAveragePrice:=0
	$st_rProductPurchaseAveragePrice:=0
	$st_rProductPurchAvgPriceAmou:=0
	$st_dProductLastStockEventDate:=!00-00-00!
	//AK: 2007-05-22
	$st_lAvgPriceStartValueFld:=0
	If (<>pr_tAvgPriceStartValueFld#"")
		$st_lAvgPriceStartValueFld:=_var ConstantNameToLong(<>pr_tAvgPriceStartValueFld)
		$st_rProductAveragePrice:=_fld ValueReal($st_lAvgPriceStartValueFld)
		$st_rProductPurchaseAveragePrice:=$st_rProductAveragePrice
	End if 
	$st_lStockBalanceStartValueFld:=0
	If (<>pr_tStockBalanceStartValueFld#"")
		$st_lStockBalanceStartValueFld:=_var ConstantNameToLong(<>pr_tStockBalanceStartValueFld)
		$st_rProductAverageBalance:=_fld ValueReal($st_lStockBalanceStartValueFld)
	End if 
	//  
End if 

_rec LOCKED_WAIT(pr_kTbl; kTrue)
If (OK#1)
	_err MESSAGE(_lang Current("Product was locked")+": "+$st_tProduct+ksCR+_lang Current("Stock event values were not saved to product"); Current method name:C684; kFalse)
Else 
	_fld VALUE_REAL_SET(kSet; pr_kStock_Balance__unit; $st_rProductStockBalance)  //AK: 2007-05-08: 
	_fld VALUE_REAL_SET(kSet; pr_kAverage_Balance; $st_rProductAverageBalance)
	_fld VALUE_REAL_SET(kSet; pr_kAverage_Price; $st_rProductAveragePrice)
	_fld VALUE_REAL_SET(kSet; pr_kPurchase_Average_Price; $st_rProductPurchaseAveragePrice)
	_fld VALUE_REAL_SET(kSet; pr_kPurch_Avg_Price_Amount; $st_rProductPurchAvgPriceAmou)
	_fld VALUE_DATE_SET(kSet; pr_kLast_Stock_Event_Date; $st_dProductLastStockEventDate)
	_rec SAVE(pr_kTbl)
End if 
_tbl WRITE_STATE(pr_kTbl; kPrevious)
$0:=$st_lSelSize
