// plugin/vue-renderer/index.js

import fs from 'fs'
import { renderPage } from './render.js'

let totalTime = performance.now()
// const elementArr = JSON.parse(fs.readFileSync('./element-arr.json', 'utf8')).element
// await init(elementArr)

let html = fs.readFileSync('./page.html', 'utf8')
const state = JSON.parse(fs.readFileSync('./state.json', 'utf8'))
let arg = JSON.stringify({ html, state })
let runStartTime = performance.now()
let pageData, i
let count = 1
for (i = 1; i <= count; i++) {
	pageData = renderPage(arg)
}
let msg = `${i - 1}. web page json length: ${pageData.length}`
console.log(msg)
runStartTime = performance.now() - runStartTime
fs.writeFileSync('./page.json', pageData)
totalTime = performance.now() - totalTime

msg =
	`* web page json length ${pageData.length}, create time: ` +
	(runStartTime / 1000).toFixed(4) +
	` seconds, total time: ` +
	(totalTime / 1000).toFixed(4) +
	` seconds, single time: ` +
	(totalTime / count / 1000).toFixed(4) +
	` seconds\n`
console.debug(msg)
