// plugin/vue-renderer/render.js
// idea taken from: https://lachlan-miller.me/articles/vue-3-pdf-customer-renderer

import { provide, defineComponent, compile, createRenderer } from '../lib.js' // 'vue', vue is using: 'vue/dist/vue.esm-bundler.js'
import { newDocument } from './element.js'
import { createNodeOps } from './nodeOps.js'
// import { newState } from '../component/nc-state.js'

import NcForm from '../component/nc-form.js'
import NcRow from '../component/nc-row.js'
import NcCol from '../component/nc-col.js'
import NcFormField from '../component/nc-form-field.js'
import NcFormFields from '../component/nc-form-fields.js'
// import NcTranslate from '../component/nc-input/nc-translate.js'
import NcSpan from '../component/nc-input/nc-span.js'
import NcLabel from '../component/nc-input/nc-label.js'
import NcInput from '../component/nc-input/nc-input.js'
import NcTextarea from '../component/nc-input/nc-textarea.js'
import NcLabelInput from '../component/nc-input/nc-label-input.js'
import NcLabelTextarea from '../component/nc-input/nc-label-textarea.js'
import NcRect from '../component/nc-draw/nc-rect.js'
import NcLine from '../component/nc-draw/nc-line.js'
import NcLineV from '../component/nc-draw/nc-line-v.js'
import NcImage from '../component/nc-draw/nc-image.js'
import NcIcon from '../component/nc-draw/nc-icon.js'
import NcBarcode from '../component/nc-draw/nc-barcode.js'

const comp = {
	NcForm,
	NcRow,
	NcCol,
	NcFormField,
	NcFormFields,
	// NcTranslate,
	NcSpan,
	NcLabel,
	NcInput,
	NcTextarea,
	NcLabelInput,
	NcLabelTextarea,
	NcRect,
	NcLine,
	NcLineV,
	NcImage,
	NcIcon,
	NcBarcode
}

const App = defineComponent({
	name: 'NcRenderApp' /* ,
	setup() {
		provide('state', state)
		return { rec: state.rec, hdr: state.hdr } // ...toRefs(state) if state is reactive
	},
	render: compile(`${html}`) */
})

function createApp(...args) {
	const nodeMap = []
	const nodeOps = createNodeOps(nodeMap) // createNodeOps generates nodeMap
	const renderer = createRenderer(nodeOps)
	const app = renderer.createApp(...args) // vue call
	for (let key in comp) {
		app.component(key, comp[key])
	}
	const { mount } = app
	app.mount = doc => {
		const proxy = mount(doc)
		doc.nodeMap = nodeMap
		return proxy
	}
	return app
}

export function renderPage(arg) {
	const param = JSON.parse(arg)
	const html = param.html.replaceAll('v-show=', 'v-if=')
	const state = param.state
	// state.rec = param.state.rec
	// state.hdr = param.state.hdr
	// console.log('html', html)
	// console.log('stateRec', stateRec)
	// const state = newState('nc-render', stateRec)
	state.rec.printing = true

	// return Object.assign({ style: appStyle }, toRefs(state)) // this is old-browser compatible version of '...state'
	// return { ...state, state } // ...toRefs(state) if state is reactive
	// components: comp, // create later by app.component(), components must be in app, here is not enough
	// Modelled after https://github.com/vuejs/vue-next/blob/master/packages/runtime-dom/src/index.ts#L61
	App.setup = () => {
		provide('state', state)
		return { rec: state.rec, hdr: state.hdr } // ...toRefs(state) if state is reactive
	}
	App.render = compile(`${html}`)

	const doc = newDocument()
	const app = createApp(App)
	app.mount(doc) // this creates doc.nodeMap
	// app.unmount() // not needed, let gc handle it
	doc.nodeMap.shift() // The shift() method removes the first item of an array, we don't need first root
	delete doc.nodeMap[0].parent

	const nodeMap = doc.nodeMap.map(item => {
		const ret = {}
		for (const key in item) {
			if (!key.startsWith('_') && key !== 'nodeMap') {
				ret[key] = item[key]
			}
		}
		if (item.__vnode && item.__vnode.props) {
			const item2 = item.__vnode.props
			ret.props = {}
			for (const key2 in item2) {
				if (item2[key2] != null && typeof item2[key2] !== 'function') {
					ret.props[key2] = item2[key2]
				}
			}
		}
		return ret
	})
	return JSON.stringify(nodeMap, null, 2)
}

// eslint-disable-next-line no-undef
globalThis.renderPage = renderPage
