// form/nc/nc-load/nc-load.js
// form/nc/nc-load/init.json

export default {
	setup() {
		const rec = state.rec
		function setQueryItem(index, event) {
			console.log(`🚀 ~ file: nc-load.js ~ line 8 ~ setQueryItem ~ index, $event`, index, event)
		}

		const mouse = ref({
			mouseover: null,
			mouseout: null,
			mousemove: null,
			click: null
		})
		function mousemove() {
			let [id, e] = arguments
			mouse.value.mousemove = id + ': ' + Math.floor(e.offsetX) + 'x' + Math.floor(e.offsetY)
		}

		// demodata
		const graphOptions = {
			heightRatio: 0.6,
			labelWidth: 120,
			itemHeight: 25,
			defaultLines: 3,
			timeBuffer: 24
		}
		const graphDemo = [
			{
				title: 'laatikoita',
				defaultElements: [{ type: 'text', inside: true }],
				heightRatio: 1,
				defaultLines: 1,
				timeBuffer: -0.1,
				boxStyle: { lineDash: 0 },
				groupDividerStyle: { lineDash: 0, stroke: '#000' },
				items: new Array(20).fill(null).map((_, index) => {
					let d = new Date('2021-06-04T23:00:00')
					var randomColor = ((Math.random() * 0xffffff) << 0).toString(16)
					return {
						id: 10 + index,
						start: new Date(d.getTime() + index * 24 * 60 * 60 * 1000),
						end: new Date(d.getTime() + (index + 1) * 24 * 60 * 60 * 1000),
						title: index,
						elements: [
							{ type: 'box', color: '#999' },
							{ type: 'rect', color: '#' + randomColor + '66', height: Math.random() * 0.7 + 0.3 }
						]
					}
				})
			},
			{
				title: 'tosi pitkä otsikko',
				tooltip: i => 'XXX' + i.title,
				items: [
					{
						id: 1,
						end: '2021-06-11T04:00:00',
						start: '2021-06-04T23:00:00',
						title: 'Foobar',
						elements: [
							{
								type: 'box',
								height: 1,
								end: '2021-06-07T23:30:00',
								start: '2021-06-04T23:00:00'
							},
							{
								type: 'text',
								end: '2021-06-07T23:30:00',
								hover: true,
								inside: true
							},
							{
								type: 'tail',
								start: '2021-06-07T23:30:00',
								end: '2021-06-11T04:00:00',
								hover: true
							},
							{
								type: 'rect',
								start: '2021-06-05T08:00:00',
								end: '2021-06-05T16:00:00',
								color: '#37a2da99',
								height: 1
							},
							{
								type: 'rect',
								start: '2021-06-06T08:00:00',
								end: '2021-06-06T16:00:00',
								color: '#37f22a99',
								height: 0.5
							},
							{
								type: 'rect',
								start: '2021-06-07T08:00:00',
								end: '2021-06-07T16:00:00',
								color: '#f009',
								height: 1,
								hover: true
							}
						]
					},
					{
						id: 2,
						start: '2021-06-11T08:00:00',
						end: '2021-06-14T04:00:00',
						title: 'Foobar2',
						tooltip: '<h1>tää on</h1> <b>Foobar</b> joopa',
						elements: [
							{
								type: 'box',
								style: {
									lineDash: [0]
								}
							},
							{
								type: 'text',
								hover: true
							}
						],
						connections: [{ to: 1, hover: false }]
					}
				]
			},
			{
				title: 'vieläkin pitempi otsikko joka vaan jatkuu ja jatkuu',
				defaultElements: [
					{ type: 'box', color: '#999' },
					{ type: 'text', inside: true }
				],
				defaultLines: 99999,
				items: new Array(10).fill(null).map((_, index) => {
					let d = new Date('2021-06-04T23:00:00')
					return {
						id: 100 + index,
						start: new Date(d.getTime() + 2 * index * 24 * 60 * 60 * 1000),
						end: new Date(d.getTime() + (2 * index + 1) * 24 * 60 * 60 * 1000),
						title: '#' + index,
						connections: [
							{
								to: 101 + index,
								type: 'arrow',
								hover: false
							}
						]
					}
				})
			},
			{
				title: 'testi pitkällä otsikolla',
				defaultElements: [{ type: 'box' }, { type: 'text', inside: true }],
				subgroups: [
					{
						title: 'kuorma',
						defaultElements: [{ type: 'text', inside: true }],
						sticky: true,
						heightRatio: 1,
						defaultLines: 1,
						timeBuffer: -0.1,
						boxStyle: { lineDash: 0 },
						groupDividerStyle: { lineDash: 0, stroke: '#000' },
						items: new Array(20).fill(null).map((_, index) => {
							let d = new Date('2021-06-04T23:00:00')
							var randomColor = ((Math.random() * 0xffffff) << 0).toString(16)
							return {
								id: 50 + index,
								start: new Date(d.getTime() + index * 24 * 60 * 60 * 1000),
								end: new Date(d.getTime() + (index + 1) * 24 * 60 * 60 * 1000),
								title: index,
								elements: [
									{ type: 'box', color: '#999' },
									{ type: 'rect', color: '#' + randomColor + '66', height: Math.random() * 0.7 + 0.3 }
								]
							}
						})
					}
				].concat(
					new Array(10).fill(null).map((_, groupIndex) => {
						var randomColor = '#' + ((Math.random() * 0xffffff) << 0).toString(16)
						return {
							title: 'subgroup' + (groupIndex + 1),
							defaultBoxColor: randomColor,
							items: new Array(10).fill(null).map((_, index) => {
								let d = new Date('2021-06-04T23:00:00')
								return {
									id: (groupIndex + 2) * 100 + index,
									start: new Date(d.getTime() + (index - 5 * Math.random()) * 24 * 60 * 60 * 1000),
									end: new Date(d.getTime() + (index + 5 * Math.random()) * 24 * 60 * 60 * 1000),
									title: 'Foobar' + index,
									connections: [
										{
											to: (groupIndex + 2) * 100 + 1 + index,
											type: 'arrow',
											hover: true
										}
									]
								}
							})
						}
					})
				)
			},
			{
				title: 'toinen',
				defaultElements: [{ type: 'box' }, { type: 'text', inside: true }],
				subgroups: new Array(10).fill(null).map((_, groupIndex) => {
					var randomColor = '#' + ((Math.random() * 0xffffff) << 0).toString(16)
					return {
						title: 'subgroup' + (groupIndex + 1),
						defaultBoxColor: randomColor,
						items: new Array(10).fill(null).map((_, index) => {
							let d = new Date('2021-06-04T23:00:00')
							return {
								id: (groupIndex + 2) * 10000 + index,
								start: new Date(d.getTime() + (index - 5 * Math.random()) * 24 * 60 * 60 * 1000),
								end: new Date(d.getTime() + (index + 5 * Math.random()) * 24 * 60 * 60 * 1000),
								title: 'Foobar' + index,
								connections: [
									{
										to: (groupIndex + 2) * 10000 + 1 + index,
										type: 'arrow',
										hover: true
									}
								]
							}
						})
					}
				})
			}
		]

		const ganttData = ref(graphDemo)
		const ganttOptions = ref(graphOptions)

		return { rec, ganttData, ganttOptions, mouse, mousemove, setQueryItem }
	}
}
