import {
	resolveComponent as _resolveComponent,
	createVNode as _createVNode,
	renderSlot as _renderSlot,
	openBlock as _openBlock,
	createBlock as _createBlock
} from '../lib.js'

function render(_ctx, _cache) {
	// const _component_nc_message = _resolveComponent('nc-message')

	return (
		_openBlock(),
		_createBlock(
			'form',
			{
				class: [
					'ui form nc-form',
					{
						mini: _ctx.size === 'mini',
						tiny: _ctx.size === 'tiny',
						small: _ctx.size === 'small',
						large: _ctx.size === 'large',
						big: _ctx.size === 'big',
						huge: _ctx.size === 'huge',
						massive: _ctx.size === 'massive'
					}
				],
				// ref: 'form', // nada: spidermonkey crashes on ref here
				id: _ctx.id
				// autocomplete: 'off'
				// onSubmit: _cache[1] || (_cache[1] = (...args) => _ctx.submit && _ctx.submit(...args))
			},
			[
				/* _createVNode(
					_component_nc_message,
					{
						size: _ctx.size,
						msg: _ctx.messageObject
					},
					null,
					8 /* PROPS * /,
					['size', 'msg']
				), */
				_renderSlot(_ctx.$slots, 'default')
			],
			42 /* CLASS, PROPS, HYDRATE_EVENTS */,
			['id']
		)
	)
}

// /src/components/nc-form.vue, see nc-main.css
// can't be template functional because it has reactive state data
// import '/src/lib/fomantic-ui/dist/components/form.css'
// import { computed, inject, ref } from '../lib.js'
// import nc from './nc-util.js'
// import createComponent from '/src/components/nc-form-col-row.js'

export default {
	render: render,
	name: 'NcForm',
	props: {
		showMessage: {
			type: Boolean,
			description: 'Do not show messages if this nc-form.',
			required: false,
			default: true
		},
		id: {
			type: String,
			description: 'Form message id.',
			required: false,
			default: undefined
		},
		size: {
			type: String,
			description: 'Form size.',
			required: false,
			default: undefined
		}
	} /* ,
	setup(props) {
		const state = inject(`state`)
		const root = ref()
		const messageObject = computed(() => {
			return state.message && state.message.id && (state.message.id === props.id ? state.message : null)
		})

		function submit() {
			console.debug('* form submit')
			return false
		}

		onMounted(function () {
			if (form.value && !state.form) {
				nc.setState(state, 'form', form.value)
			}
		})

		return { submit, form, messageObject }
	} */
}
