//%attributes = {}
//******************************************************************************
//Method: SDA_TileWindows(bResiz;bMethodWindowsOnly;bResizeAll)
//Written by  Tod Gentille on 10/16/97
//
//Purpose: Tile and {resize} all the regular {method} windows in the design enviro
//Only resizes the window if it is bigger than the max width or height settings.
//
//$1 -boolean  if true also resize the windows
//$2 - boolean if true limit to method windows only
//$3 - if true always resize the windows regardless of their size
//Modified 10/29/98 Tod Gentille
//Copyright 1997 Syncor Systems, Inc.
//******************************************************************************
C_BOOLEAN:C305($1; $2; $bAllow_Win_Resize; $bLimitToMethodWindows)
C_BOOLEAN:C305($3; $bAlwaysResize)
C_LONGINT:C283($lLeft; $lTop; $lWR; $lWB; $lWL; $lWT; $lWnd; $lCurWinRef)
ARRAY LONGINT:C221($alWinRef; 0)
C_LONGINT:C283($lScreenHeight; $lScreenWidth)
C_LONGINT:C283($lMIN_MDI_HEIGHT; $lSTART_TOP; $lSTART_LEFT)
C_LONGINT:C283($lWIDTH_OFFSET; $lHEIGHT_OFFSET)
C_LONGINT:C283($lMAX_WIN_HEIGHT; $lMAX_WIN_WIDTH)
C_LONGINT:C283($lWinHeight; $lWinWidth)
C_LONGINT:C283($sda_lOnlyFrontmost)

$bAllow_Win_Resize:=$1
$bLimitToMethodWindows:=$2
$bAlwaysResize:=$3

//----------- Declare Local Constants ----------
$lMIN_MDI_HEIGHT:=650  // if the MDI window is smaller than this tiling will not do anything
$lSTART_TOP:=80  //if you don't use the 4D toolbar you can start at 40
$lSTART_LEFT:=10
$lWIDTH_OFFSET:=10  //how much to the right to move each succesive window
$lHEIGHT_OFFSET:=20  //how much down to move each succesive window
//If a window is larger than the following constant it will be resized to the
//size in the constant. 
$lMAX_WIN_HEIGHT:=600
$lMAX_WIN_WIDTH:=900

$lScreenHeight:=Screen height:C188
$lScreenWidth:=Screen width:C187

If ($lScreenHeight>$lMIN_MDI_HEIGHT)  //make sure main MDI win is large enough
	
	//Fill array with ALL window references, then resize all regular windows that 
	//belong to the design process   
	WINDOW LIST:C442($alWinRef)
	$lLeft:=$lSTART_LEFT
	$lTop:=$lSTART_TOP
	
	If (<>lSDA_DesignPID=0)
		<>lSDA_DesignPID:=SDA_util_ProcessNum
	End if   //  If (<>lSDA_DesignPID=0)
	
	If (<>lbSDA_Window=1)  //PM: 2005-12-06
		$sda_lOnlyFrontmost:=kTrue
		ARRAY LONGINT:C221($alWinRef; 1)  //limit to frontmost window
		$lLeft:=66
	Else 
		$sda_lOnlyFrontmost:=kFalse
	End if 
	
	
	For ($lWnd; 1; Size of array:C274($alWinRef))  //for each window
		$lCurWinRef:=$alWinRef{$lWnd}
		
		If (SDA_util_IsValidWindowType($bLimitToMethodWindows; $lCurWinRef))  //if a design window of the specified type
			
			GET WINDOW RECT:C443($lWL; $lWT; $lWR; $lWB; $lCurWinRef)
			$lWinHeight:=$lWB-$lWT
			$lWinWidth:=$lWR-$lWL
			
			//------------------- Resize -----------------        
			If ($bAllow_Win_Resize)  //If enabled, resize any windows that are too large
				
				//---------- Check for window too tall, and resize ----------          
				If (($lWinHeight>$lMAX_WIN_HEIGHT) | ($bAlwaysResize))  //if window is too tall or always resize selected
					$lWB:=$lWT+$lMAX_WIN_HEIGHT
					$lWinHeight:=$lMAX_WIN_HEIGHT
				End if   //        If (($lWinHeight>$lMAX_WIN_HEIGHT) | ($bAlwaysResize))  `if window is to
				
				//---------- Check for window too wide, and resize ----------           
				If (($lWinWidth>$lMAX_WIN_WIDTH) | ($bAlwaysResize))  //if window is too wide or always resize selected
					$lWR:=$lWL+$lMAX_WIN_WIDTH
					$lWinWidth:=$lMAX_WIN_WIDTH
				End if   //        If (($lWinWidth>$lMAX_WIN_WIDTH) | ($bAlwaysResize))  `if window is too 
				
			End if   //      If ($bAllow_Win_Resize)  `If enabled, resize any windows that are too larg
			//-------------------- End Resize Window -------------------  
			
			$lWR:=$lLeft+$lWinWidth
			$lWB:=$lTop+$lWinHeight
			
			If ($lWR>$lScreenWidth)  //if the window is off to the right 
				$lLeft:=$lSTART_LEFT  // start retiling from the top
				$lTop:=$lSTART_TOP
				
			Else   //window width is not off
				
				If ($lWB>$lScreenHeight)  //if window height is off
					$lLeft:=$lSTART_LEFT
					$lTop:=$lSTART_TOP
				End if   //        If ($lWB>$lScreenHeight)  `if window height is off
				
			End if   //      If ($lWR>$lScreenWidth)  `if the window is off to the right 
			
			//Do it again in case it changed. -hey integer math is fast
			$lWR:=$lLeft+$lWinWidth
			$lWB:=$lTop+$lWinHeight
			$lWL:=$lLeft
			$lWT:=$lTop
			
			SET WINDOW RECT:C444($lWL; $lWT; $lWR; $lWB; $lCurWinRef)
			$lLeft:=$lLeft+$lWIDTH_OFFSET
			$lTop:=$lTop+$lHEIGHT_OFFSET
			
		End if   //    If (SDA_util_IsValidWindowType ($bLimitToMethodWindows;$lCurWinRef))  `if a 
		
	End for   //  For ($lWnd;1;Size of array($alWinRef))  `for each window
	
	If ($sda_lOnlyFrontmost=kTrue)
		
	End if 
	
Else   //screen height is under minimum pixel setting
	_info_ ALERT(<>SDA_WINDOW_TOO_SMALL)
End if   //If ($lScreenHeight>$lMIN_MDI_HEIGHT)  `make sure main MDI win is large enough


