//%attributes = {}
// Method: _mb4d_MethModuleCodeUpdate 
// 06.10.12, 16:45:02 / MG_PM
// © Copyright Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
//*==============================================================================
//Project method : svn_updateMethodModuleCode
// Public
//
//DESCRIPTION :
//  This method fills an array of module code (one element for each method name) 
//  and makes a list of unique (deduped) module code
//  This is only working on the method name array
//
// PARAMETRES :
//  $1 (POINTER) => array test pointer, method names (not modified)
//  $2 (POINTER) => array test pointer, module code for the method (modified)
//  $3 (POINTER) => array test pointer, module code list (modified)
//  
//NOTES : 
//
//EXAMPLE : 
//
//CREATION : Bruno LEGAY - 29/08/06, 20:03:34 - v1.00.00
//*===============================================================================

C_POINTER:C301($1)  //method names array
C_POINTER:C301($2)  //module code for the method array 
C_POINTER:C301($3)  //module code list

C_POINTER:C301($vp_methodNameArrayPtr)  //method names array
C_POINTER:C301($vp_methodModuleCodeArrayPtr)  //module code for the method array 
C_POINTER:C301($vp_moduleCodeListArrayPtr)  //module code list
C_BOOLEAN:C305($4; $vb_exportWithout__svn_param_mth)  //Export method even without an xxx__svn_param method for the module (if it looks like they have a module prefix)
C_BOOLEAN:C305($5; $vb_exportAll)  //Export all methods

C_LONGINT:C283($vl_NbParam)
$vl_NbParam:=Count parameters:C259
If ($vl_NbParam>2)
	$vp_methodNameArrayPtr:=$1
	$vp_methodModuleCodeArrayPtr:=$2
	$vp_moduleCodeListArrayPtr:=$3
	
	Case of 
		: ($vl_NbParam=3)
			$vb_exportWithout__svn_param_mth:=False:C215
			$vb_exportAll:=False:C215
			
		: ($vl_NbParam=4)
			$vb_exportWithout__svn_param_mth:=$4
			$vb_exportAll:=False:C215
			
		Else 
			//: ($vl_NbParam=5)
			$vb_exportWithout__svn_param_mth:=$4
			$vb_exportAll:=$5
			
	End case 
	
	
	//Checking the pointer types
	If (((Type:C295($vp_methodNameArrayPtr->)=Text array:K8:16) & (Type:C295($vp_methodModuleCodeArrayPtr->)=Text array:K8:16) & (Type:C295($vp_moduleCodeListArrayPtr->)=Text array:K8:16)))
		
		ARRAY TEXT:C222($tt_moduleCodeList; 0)
		ARRAY LONGINT:C221($_mb4d_alMethodCount; 0)
		
		C_TEXT:C284($vt_methodName; $vt_methodModuleCode)
		C_LONGINT:C283($_mb4d_lIndex; $_mb4d_lCodeListIndex; $vl_Pos; $vl_NameArrSize; $_mb4d_lCharIndex)
		$_mb4d_lCodeListIndex:=0
		
		//Presize the array of method module code to the same size a the method name array
		$vl_NameArrSize:=Size of array:C274($vp_methodNameArrayPtr->)
		_arr RESIZE($vp_methodModuleCodeArrayPtr; $vl_NameArrSize)
		
		_thm OPEN($vl_NameArrSize; "Creating method module code..."; "Method module code"; True:C214)
		For ($_mb4d_lIndex; 1; $vl_NameArrSize)  //Looping on all method names
			
			If ($_mb4d_lIndex%50=0)
				//GOTO XY(1;1)
				//MESSAGE("1/2, Creating method module code: "+String($_mb4d_lIndex)+" / "+String($vl_NameArrSize))
				_thm UPDATE($_mb4d_lIndex)
			End if 
			
			If (_thm Cancelled=kTrue)
				$_mb4d_lIndex:=$vl_NameArrSize+1
			Else 
				$vt_methodName:=$vp_methodNameArrayPtr->{$_mb4d_lIndex}
				$vp_methodModuleCodeArrayPtr->{$_mb4d_lIndex}:=""
				
				//Getting the module code from the method name
				$vt_methodModuleCode:=_mb4d_ModuleCodeFromMethName($vt_methodName)
				
				If (Length:C16($vt_methodModuleCode)<1)
					If (Substring:C12($vt_methodName; 1; 1)="(")
						IDLE:C311  //deletedmethod
					Else 
						TRACE:C157
					End if 
					
					$vt_methodModuleCode:=$vt_methodName
				End if 
				
				If (Length:C16($vt_methodModuleCode)>0)
					//now looking if we have a method "xxx__svn_param" in the list of methods names...
					$vl_found:=0  //Find in array($vp_methodNameArrayPtr->;_mz_svn__ModCodeToMethParamNam ($vt_methodModuleCode))
					
					Case of 
						: ($vl_found>0)  //There is a "xxx__svn_param" method :-)
							//So this method will be exported as part of the "xxx" module
							
							//we _str_ ToLower all module codes
							//$vt_methodModuleCode:=_str_ ToLower($vt_methodModuleCode)
							
						: ((Length:C16($vt_methodModuleCode)>0) & (Length:C16($vt_methodModuleCode)<=10) & $vb_exportWithout__svn_param_mth)  //The is something which looks like a module code (between 1 and 4 characters followed by "_") and we have the option $vb_exportWithout__svn_param_mth
							//$vt_methodModuleCode:=_str_ ToLower($vt_methodModuleCode)
							
						: ($vb_exportAll)  //we have the option $vb_exportAll, we will export in another module : 
							$vt_methodModuleCode:="_other"
							
						Else 
							$vt_methodModuleCode:=""
					End case 
					
					If (Length:C16($vt_methodModuleCode)>0)
						//set the module code in the array corresponding to the method name
						$vp_methodModuleCodeArrayPtr->{$_mb4d_lIndex}:=$vt_methodModuleCode
						
						//Now we are checking if the module has already been listed in the module code list
						$_mb4d_lCodeListPos:=Find in array:C230($tt_moduleCodeList; $vt_methodModuleCode)
						If ($_mb4d_lCodeListPos<1)
							//It is the first time, so we will add it...
							$_mb4d_lCodeListIndex:=$_mb4d_lCodeListIndex+1
							If ($_mb4d_lCodeListIndex>Size of array:C274($tt_moduleCodeList))
								INSERT IN ARRAY:C227($tt_moduleCodeList; $_mb4d_lCodeListIndex; 1000)
								INSERT IN ARRAY:C227($_mb4d_alMethodCount; $_mb4d_lCodeListIndex; 1000)
							End if 
							$tt_moduleCodeList{$_mb4d_lCodeListIndex}:=$vt_methodModuleCode
							$_mb4d_alMethodCount{$_mb4d_lCodeListIndex}:=1
						Else 
							$_mb4d_alMethodCount{$_mb4d_lCodeListPos}:=$_mb4d_alMethodCount{$_mb4d_lCodeListPos}+1
						End if 
						
					End if 
					
				End if 
				
			End if 
		End for 
		
		ARRAY TEXT:C222($tt_moduleCodeList; $_mb4d_lCodeListIndex)  //resize smaller
		ARRAY LONGINT:C221($_mb4d_alMethodCount; $_mb4d_lCodeListIndex)  //resize smaller
		For ($_mb4d_lIndex; 1; $_mb4d_lCodeListIndex)  //add count to module text
			$tt_moduleCodeList{$_mb4d_lIndex}:=$tt_moduleCodeList{$_mb4d_lIndex}+ksSpace+"("+String:C10($_mb4d_alMethodCount{$_mb4d_lIndex})+")"
		End for 
		COPY ARRAY:C226($tt_moduleCodeList; $vp_moduleCodeListArrayPtr->)
		ARRAY TEXT:C222($tt_moduleCodeList; 0)
		
		_thm CLOSE
		
	Else 
		_info_ ALERT(Current method name:C684+" $1 and/or $2 and/or $3 parameters are not of the expected type (array text point"+"er)")
	End if 
	
Else 
	_info_ ALERT(Current method name:C684+" not enough parameters")
End if 
