//%attributes = {}
// Method: _rc_BLOB_RECEIVE
// 18.06.12, 16:27:28 / MG_PM
// © Copyright Manage Applications
// Purpose: 
// _rct_BlobPtrReceive, _rc_OnePacketReceive ->, _tcp_ BlobReceive, _rct_BlobSend, _tcp_ BlobSend
// ------------------------------------------------------------
If (<>_rc_fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

If (_rc_fReceiveParamData)
	// receive parameter data blob, see: _rc_ CALL
	
	If (_rc_lReceiveParamOffset=0)  // faster first receive
		_rc_lReceiveParamOffset:=_rc_lReceiveParamBlobSize  // how much we need, after plugin call received data amount
		If (<>_rc_fProfile)
			_info_ CALL_PROFILE(kStart; Current method name:C684+": MA_TCP_ReceiveBlob")
		End if 
		_rc_lBlobSize:=MA_TCP_ReceiveBlob(_rc_lSocket; _rc_xReceiveBlob; _rc_lReceiveParamOffset; _rc_lReceiveLoopIdleCount)
		If (<>_rc_fProfile)
			_info_ CALL_PROFILE(kStop; Current method name:C684+": MA_TCP_ReceiveBlob")
		End if 
		// after MA_TCP_ReceiveBlob call _rc_lReceiveParamOffset will contain actual received bytes
		
		If (_rc_lReceiveParamOffset>_rc_lReceiveParamBlobSize)
			_err MESSAGE(_lang Current("MA_TCP_ReceiveBlob received more parameter than needed"); Current method name:C684; kFalse)
			TRACE:C157
		End if 
		
		Case of 
			: (_rc_lBlobSize=1)
				<>_rc_lReceiveTypeTcp:=<>_rc_lReceiveTypeTcp+1
			: (_rc_lBlobSize=2)
				<>_rc_lReceiveTypeBuffer:=<>_rc_lReceiveTypeBuffer+1
			: (_rc_lBlobSize=0)
				<>_rc_lReceiveTypeNothing:=<>_rc_lReceiveTypeNothing+1  // collect statistics
			: (_rc_lBlobSize=-1)
				// ok error, disconnected
			: (_rc_lBlobSize<0)
				_rct_TCP_ERROR(_rc_lSocket; _rc_lBlobSize; "MA_TCP_ReceiveBlob"; Current method name:C684)
				<>_rc_lReceiveTypeNothing:=<>_rc_lReceiveTypeNothing+1  // collect statistics
		End case 
	End if 
	
	Case of 
		: (_rc_lReceiveParamOffset>=_rc_lReceiveParamBlobSize)
			_rc_lBlobSize:=_rc_lReceiveParamOffset  // don't mind about the errors
		: ((_rc_lReceiveParamOffset=0) & _rc_fServerProcess & (<>_rc_lBlobReceiveServerWait>0))
			//IDLE  // no data, go to sleep
		: (_rc_lBlobSize<0)
			// error here
		Else 
			_rc_lBlobSize:=_rct_BlobPtrReceive
			If ((_rc_lReceiveParamOffset<_rc_lReceiveParamBlobSize) & (_rc_lBlobSize>0))
				_rc_lBlobSize:=0  // = wait for more data
			End if 
	End case 
	
Else 
	// receive header blob
	
	If (_rc_lReceiveHeaderOffset=0)  // faster first receive
		
		//C_LONGINT($_rc_lHeaderTimeout)
		//C_BOOLEAN($_rc_fHeaderTimeout)
		//
		//  //$_rc_lHeaderTimeout:=0
		//  //$_rc_fHeaderTimeout:=False
		//Repeat 
		_rc_lReceiveHeaderOffset:=<>_rc_lHeaderLength  // how much we need, after plugin call received data amount
		If (<>_rc_fProfile)
			_info_ CALL_PROFILE(kStart; Current method name:C684+": MA_TCP_ReceiveBlob")
		End if 
		_rc_lBlobSize:=MA_TCP_ReceiveBlob(_rc_lSocket; _rc_xReceiveHeaderBlob; _rc_lReceiveHeaderOffset; _rc_lReceiveLoopIdleCount)
		If (<>_rc_fProfile)
			_info_ CALL_PROFILE(kStop; Current method name:C684+": MA_TCP_ReceiveBlob")
		End if 
		
		If (_rc_lReceiveHeaderOffset><>_rc_lHeaderLength)
			_err MESSAGE(_lang Current("MA_TCP_ReceiveBlob received more header than needed"); Current method name:C684; kFalse)
			TRACE:C157
		End if 
		
		Case of 
			: (_rc_lBlobSize=1)
				<>_rc_lReceiveTypeTcp:=<>_rc_lReceiveTypeTcp+1
			: (_rc_lBlobSize=2)
				<>_rc_lReceiveTypeBuffer:=<>_rc_lReceiveTypeBuffer+1
			: (_rc_lBlobSize=0)
				<>_rc_lReceiveTypeNothing:=<>_rc_lReceiveTypeNothing+1  // collect statistics
			: (_rc_lBlobSize=-1)
				// ok error, disconnected
			: (_rc_lBlobSize<0)
				_rct_TCP_ERROR(_rc_lSocket; _rc_lBlobSize; "MA_TCP_ReceiveBlob"; Current method name:C684)
				<>_rc_lReceiveTypeNothing:=<>_rc_lReceiveTypeNothing+1  // collect statistics
		End case 
		
		//Case of 
		//: (_rc_lReceiveHeaderOffset>0)
		//  // all ok, get out of loop
		//: (<>_rc_lBlobReceiveHeaderTimeoutMs<=0)
		//$_rc_fHeaderTimeout:=True
		//: ($_rc_lHeaderTimeout=0)
		//$_rc_lHeaderTimeout:=Milliseconds+<>_rc_lBlobReceiveHeaderTimeoutMs
		//DELAY PROCESS(Current process;0)  // some delay if no data came
		//: (Milliseconds>$_rc_lHeaderTimeout)
		//$_rc_fHeaderTimeout:=True  // exit receive
		//Else 
		//DELAY PROCESS(Current process;0)  // some delay if no data came
		//End case 
		//
		//Until ((_rc_lReceiveHeaderOffset>0) | (_rc_lBlobSize<0) | $_rc_fHeaderTimeout)
		
	End if 
	
	Case of 
		: (_rc_lReceiveHeaderOffset>=<>_rc_lHeaderLength)
			_rc_lBlobSize:=_rc_lReceiveHeaderOffset  // don't min about the errors
		: ((_rc_lReceiveHeaderOffset=0) & _rc_fServerProcess & (<>_rc_lBlobReceiveServerWait>0))
			//IDLE  // no data, server should go to sleep
		: (_rc_lBlobSize<0)
			// error here
		Else 
			// client will wait for a while
			_rc_lBlobSize:=_rct_BlobPtrReceive
			If ((_rc_lReceiveHeaderOffset<<>_rc_lHeaderLength) & (_rc_lBlobSize>0))
				_rc_lBlobSize:=0  // = wait for more data
			End if 
	End case 
	
End if 

If (<>_rc_fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 