//%attributes = {}
// Project Method: Calendar_PlacePictureObject

// Searching for answers? Be sure to check out the "About..." menu located in the
// Apple menu (Macintosh) or the Help menu (Windows). There you can find online
// help for this example database, as well as a listing of numerous 4D resources
// available to you.

// Method created by Dave Batton, DataCraft.

// Called from the Calendar_PlaceEvents method to place Picture events.

C_LONGINT:C283($cal_lObjectNum; $1)

$cal_lObjectNum:=$1

Case of 
	: ($cal_lObjectNum<1)
	: ($cal_lObjectNum>cal_lMaxPictureObjects)
	Else 
		_O_C_STRING:C293(31; $cal_varObjectName)
		C_POINTER:C301($cal_varPtr)
		C_LONGINT:C283($cal_boxNumber; $cal_boxLeft; $cal_boxTop; $cal_boxRight; $cal_boxBottom; $cal_imageWidth; $cal_imageHeight)
		C_LONGINT:C283($cal_left; $cal_top; $cal_right; $cal_bottom)
		
		$cal_varObjectName:="cal_gPict"+String:C10($cal_lObjectNum)
		
		// Update the arrays that let us track which record the object is associated with.
		cal_TRACKING_ELEM_ADD($cal_varObjectName)
		
		// Get a pointer to the variable object.
		$cal_varPtr:=Get pointer:C304($cal_varObjectName)
		
		// Stick the picture from the record in the variable.
		//$cal_varPtr->:= ?[To_Do]Picture?  `PM: ??
		
		// Find the box into which we want to place this event.
		$cal_boxNumber:=do_adDate_{cal_lEventIndex}-cal_dFirstBoxDate+1
		OBJECT GET COORDINATES:C663(*; "Box"+String:C10($cal_boxNumber); $cal_boxLeft; $cal_boxTop; $cal_boxRight; $cal_boxBottom)
		
		PICTURE PROPERTIES:C457($cal_varPtr->; $cal_imageWidth; $cal_imageHeight)
		
		$cal_left:=$cal_boxRight-$cal_imageWidth-2
		$cal_top:=$cal_boxBottom-$cal_imageHeight-2
		$cal_right:=$cal_left+$cal_imageWidth
		$cal_bottom:=$cal_top+$cal_imageHeight
		
		// Now make sure our picture variable doesn't extend outside of the date box.
		If ($cal_left<($cal_boxLeft+2))
			$cal_left:=$cal_boxLeft+2
		End if 
		If ($cal_top<($cal_boxTop+2))
			$cal_top:=$cal_boxTop+2
		End if 
		
		// Move the picture object into place.
		OBJECT MOVE:C664($cal_varPtr->; $cal_left; $cal_top; $cal_right; $cal_bottom; *)
End case 
