//%attributes = {}
// Method: ldcap_BLOB_SAVE
// 2009.02.27-15:15:46 / Pasi Mankinen
// © Copyright 2009 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_TEXT:C284($1; $ld_tLoadGroup; $2; $ld_tPrfName)
C_LONGINT:C283($ld_lPosStart; $ld_lPosEnd; $ld_lLength; $ld_lIndex; $ld_lIndex2; $ld_lResize)
//COMPILER_ld_cap_

$ld_tLoadGroup:=$1
$ld_tPrfName:=$2

If (cap_lCacheInUse=1)
	SET BLOB SIZE:C606(ldcap_xBlobTmp; 0)
	
	If (_arr apSize(->ldcap_apCapArr)<1)
		//_err MESSAGE (_lang Current ("Capacity arrays size is zero")+": "+ksQuoteStart+$ld_tLoadGroup+"|"+$ld_tPrfName+ksQuoteEnd;Current method name;kFalse)
	End if 
	
	If (_arr apBlob(kSave; ->ldcap_xBlobTmp; ->ldcap_apCapArr)=kFalse)
		_err MESSAGE(_lang Current("Capacity arrays could not be saved to blob")+": "+ksQuoteStart+$ld_tLoadGroup+"|"+$ld_tPrfName+ksQuoteEnd; Current method name:C684; kFalse)
	Else 
		
		$ld_lIndex:=Find in array:C230(ldcap_atBlobLoadGroup; $ld_tLoadGroup+"|"+$ld_tPrfName)
		If ($ld_lIndex<1)
			//new load group
			//just list of load group  name +"|"+ prf name
			//not same size as ldcap_atBlobCapacity and other arrays
			$ld_lIndex:=Size of array:C274(ldcap_atBlobLoadGroup)+1
			ARRAY TEXT:C222(ldcap_atBlobLoadGroup; $ld_lIndex)
			ldcap_atBlobLoadGroup{$ld_lIndex}:=$ld_tLoadGroup+"|"+$ld_tPrfName
		End if 
		
		$ld_lIndex:=Find in array:C230(ldcap_atBlobCapacity; $ld_tPrfName)
		If ($ld_lIndex>0)
			IDLE:C311  //was here already
		Else 
			_blob_ COMPRESS(kSet; ->ldcap_xBlobTmp)  //blobs are generally 150 - 200 kb, will take much memory if not compressed
			
			If ($ld_lIndex<1)
				//new save
				$ld_lIndex:=Size of array:C274(ldcap_atBlobCapacity)
				If ($ld_lIndex=0)
					$ld_lPosStart:=0  //blobs have zero-based index
				Else 
					$ld_lPosStart:=ldcap_alBlobEndPos{$ld_lIndex}+1
				End if 
				
				$ld_lLength:=BLOB size:C605(ldcap_xBlobTmp)
				$ld_lPosEnd:=$ld_lPosStart+BLOB size:C605(ldcap_xBlobTmp)-1  //set new end
				
				$ld_lIndex:=$ld_lIndex+1
				ARRAY TEXT:C222(ldcap_atBlobCapacity; $ld_lIndex)
				ARRAY LONGINT:C221(ldcap_alBlobStartPos; $ld_lIndex)
				ARRAY LONGINT:C221(ldcap_alBlobEndPos; $ld_lIndex)
				
			Else 
				//update old, not in use!
				
				$ld_lPosStart:=ldcap_alBlobStartPos{$ld_lIndex}
				$ld_lPosEnd:=ldcap_alBlobEndPos{$ld_lIndex}
				$ld_lLength:=$ld_lPosEnd-$ld_lPosStart+1
				
				$ld_lPosEnd:=$ld_lPosStart+BLOB size:C605(ldcap_xBlobTmp)-1  //set new end
				
				Case of 
					: ($ld_lLength<BLOB size:C605(ldcap_xBlobTmp))
						$ld_lLength:=BLOB size:C605(ldcap_xBlobTmp)-$ld_lLength
						INSERT IN BLOB:C559(ldcap_xBlobLoadGroupAll; $ld_lPosStart; $ld_lLength)  //add new bytes to blob start
						$ld_lResize:=kTrue
						
					: ($ld_lLength>BLOB size:C605(ldcap_xBlobTmp))
						$ld_lLength:=$ld_lLength-BLOB size:C605(ldcap_xBlobTmp)
						DELETE FROM BLOB:C560(ldcap_xBlobLoadGroupAll; $ld_lPosStart; $ld_lLength)
						$ld_lLength:=-$ld_lLength
						$ld_lResize:=kTrue
					Else 
						$ld_lResize:=kFalse
				End case 
				
				If ($ld_lResize=kTrue)
					//fix indexes after this blob
					For ($ld_lIndex2; $ld_lIndex+1; Size of array:C274(ldcap_alBlobStartPos))
						ldcap_alBlobStartPos{$ld_lIndex2}:=ldcap_alBlobStartPos{$ld_lIndex2}+$ld_lLength
						ldcap_alBlobEndPos{$ld_lIndex2}:=ldcap_alBlobEndPos{$ld_lIndex2}+$ld_lLength
					End for 
				End if 
				
				$ld_lLength:=BLOB size:C605(ldcap_xBlobTmp)
				
			End if 
			
			$ld_lLength:=$ld_lPosEnd-$ld_lPosStart+1
			ldcap_atBlobCapacity{$ld_lIndex}:=$ld_tPrfName
			ldcap_alBlobStartPos{$ld_lIndex}:=$ld_lPosStart
			ldcap_alBlobEndPos{$ld_lIndex}:=$ld_lPosEnd
			If ($ld_lLength#BLOB size:C605(ldcap_xBlobTmp))
				TRACE:C157
				_err MESSAGE(_lang Current("Blob size calculation error")+": "+ksQuoteStart+$ld_tLoadGroup+"|"+$ld_tPrfName+ksQuoteEnd; Current method name:C684; kFalse)
			End if 
			//COPY BLOB (srcBLOB; dstBLOB; srcOffset; dstOffset; len)
			COPY BLOB:C558(ldcap_xBlobTmp; ldcap_xBlobLoadGroupAll; 0; $ld_lPosStart; $ld_lLength)
			
			$ld_lIndex:=Size of array:C274(ldcap_alBlobStartPos)
			If (ldcap_alBlobEndPos{$ld_lIndex}#(BLOB size:C605(ldcap_xBlobLoadGroupAll)-1))
				TRACE:C157
				_err MESSAGE(_lang Current("Blob size error")+": "+ksQuoteStart+$ld_tLoadGroup+"|"+$ld_tPrfName+ksQuoteEnd; Current method name:C684; kFalse)
			End if 
			
		End if 
		
	End if 
	
	SET BLOB SIZE:C606(ldcap_xBlobTmp; 0)
End if 

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 
