//%attributes = {}
// Method: wo_WOS_VALUES_UPDATE
// 2005.10.25-16:46:16 / Arto Kokkila
// © Copyright 2005 Manage Applications
// Purpose: 
// 
// see and change also: 
// ld_wpe_TO_ALL_ARR_HOURS_SET
// ld_calc_WPE_TO_ARR_HOURS_SET
// ld_RAW_MATERIAL_PHASE_UPDATE
// wo_WOS_VALUES_UPDATE
// ------------------------------------------------------------
C_TEXT:C284($1; $wo_tProduction_lot; $2; $wo_tWork; $wo_tWorkLoadGroup; $wo_tWosPhaseState; $4; $wo_tCompanyId)
C_POINTER:C301($wo_pPhaseNumArr; $wo_pWorkTimeArr; $wo_pSetupTimeArr; $wo_pWorkLoadGroupArr; $wo_pSubcontractArr; $wo_pSupplierArr)
C_REAL:C285($3; $wo_rStartedAmount; $wo_rWorkTime; $wo_rExtraHours; $wo_rLastPhaseExtraHours; $wo_rMinimumWorkTime)
Case of 
	: (Count parameters:C259>=4)
		$wo_tProduction_lot:=$1
		$wo_tWork:=$2
		$wo_rStartedAmount:=$3
		$wo_tCompanyId:=$4
	Else 
		$wo_lUpdateOptions:=0
		$wo_tProduction_lot:=_fld ValueStr(wo_kProduction_Lot)
		$wo_tWork:=_fld ValueStr(wo_kWork__Position_Num_id)
		$wo_rStartedAmount:=_fld ValueReal(wo_kStarted_Amount)
		$wo_tCompanyId:=_fld ValueStr(wo_kCompany_id)
End case 

_txt:=$wo_tWork
If (_qry Fld(wpe_kTbl; wpe_kWork__Position_Num_id; "="; ->_txt; ""; kFalse)>0)
	_txt:=$wo_tProduction_lot
	
	_ord FLD(wpe_kTbl; wpe_kPhase_Number; kTrue)  //PM: 2008-09-30, must be in order
	_sel SEL_TO_ARR(_fld PtrToFldNumArr(wpe_kPhase_Number; wpe_kWork_Time__unit; wpe_kSetup_Time__lot; wpe_kWork_Load_Group_id; wpe_kSubcontract; wpe_kSupplier_id); _fld PtrToFldArr(wpe_kPhase_Number; wpe_kWork_Time__unit; wpe_kSetup_Time__lot; wpe_kWork_Load_Group_id; wpe_kSubcontract; wpe_kSupplier_id))
	$wo_pPhaseNumArr:=_fld ArrPtr(wpe_kPhase_Number)
	$wo_pWorkTimeArr:=_fld ArrPtr(wpe_kWork_Time__unit)
	$wo_pSetupTimeArr:=_fld ArrPtr(wpe_kSetup_Time__lot)
	$wo_pWorkLoadGroupArr:=_fld ArrPtr(wpe_kWork_Load_Group_id)
	$wo_pSubcontractArr:=_fld ArrPtr(wpe_kSubcontract)
	$wo_pSupplierArr:=_fld ArrPtr(wpe_kSupplier_id)
	_tbl WRITE_STATE(wos_kTbl; kTrue)
	$wo_lPhaseArrSize:=Size of array:C274($wo_pPhaseNumArr->)
	For ($wo_lPhaseIndex; 1; $wo_lPhaseArrSize)
		_txt:=$wo_tProduction_lot
		_qry Fld(wos_kTbl; wos_kProduction_Lot; "="; ->_txt; "*"; kFalse)
		_long:=$wo_pPhaseNumArr->{$wo_lPhaseIndex}
		If (_qry Fld(wos_kTbl; wos_kWork_Phase; "="; ->_long; "&"; kFalse)>0)
			
			$wo_tWosPhaseState:=_fld ValueStr(wos_kWork_Phase_State)
			If (($wo_tWosPhaseState=<>wo_sState_Finished) | ($wo_tWosPhaseState=<>wo_sState_Canceled))  //AK: 2008-04-07 | ($wo_tWosPhaseState=<>wo_sState_Stopped))
				IDLE:C311  //only open phases are allowed to change            
			Else 
				_rec LOCKED_WAIT(wos_kTbl; kTrue)
				If (OK=1)
					
					$wo_tWorkLoadGroup:=$wo_pWorkLoadGroupArr->{$wo_lPhaseIndex}
					$wo_rMinimumWorkTime:=ld_wlg_MinimumWorkTimeGet($wo_tWorkLoadGroup)
					$wo_rExtraHours:=ld_wlg_ExtraTimeGet($wo_tWorkLoadGroup)
					If ($wo_lPhaseIndex=$wo_lPhaseArrSize)
						$wo_rLastPhaseExtraHours:=ld_wlg_LastPhaseExtraTimeGet($wo_tWorkLoadGroup)
						If ($wo_rLastPhaseExtraHours#0)
							$wo_rExtraHours:=$wo_rLastPhaseExtraHours
						End if 
						
						If ($wo_tCompanyId#"")  //PM: 2008-09-30
							$wo_rLastPhaseExtraHours:=ld_co_WorkAdvanceTimeGet($wo_tCompanyId)
							If ($wo_rLastPhaseExtraHours#0)
								$wo_rExtraHours:=$wo_rExtraHours+$wo_rLastPhaseExtraHours
							End if 
						End if 
						
					End if 
					Case of 
						: ($wo_tWorkLoadGroup=<>w_tRawMaterialLoadGroupId)
							//is raw material phase              
							$wo_rWorkTime:=$wo_rMinimumWorkTime
						: ($wo_pSubcontractArr->{$wo_lPhaseIndex}=True:C214)
							//is subcontract phase                  
							$wo_rWorkTime:=$wo_rMinimumWorkTime
						Else 
							//is own phase
							$wo_rWorkTime:=$wo_pWorkTimeArr->{$wo_lPhaseIndex}*$wo_rStartedAmount
							If (<>wo_fOnAsAika)
								$wo_rWorkTime:=$wo_rWorkTime+$wo_pSetupTimeArr->{$wo_lPhaseIndex}
							End if 
							If ($wo_rWorkTime<=0)
								//how about setup time here?
								$wo_rWorkTime:=ld_wlg_DefaultWorkTimeGet($wo_tWorkLoadGroup)
								$wo_rWorkTime:=$wo_rWorkTime*$wo_rStartedAmount
							End if   // ($ld_rWorkTime>0)
							If ($wo_rWorkTime<$wo_rMinimumWorkTime)
								$wo_rWorkTime:=$wo_rMinimumWorkTime
							End if 
					End case 
					_fld VALUE_REAL_SET(kSet; wos_kPlanned_Work_Time; $wo_rWorkTime)
					_fld VALUE_REAL_SET(kSet; wos_kWork_Time; $wo_rWorkTime)
					_fld VALUE_REAL_SET(kSet; wos_kExtra_Hours; $wo_rExtraHours)
					_rec SAVE(wos_kTbl)
					wos_AMOUNTS_AND_STATE_UPDATE(kFalse)
					
					If ($wo_lPhaseIndex>=$wo_lPhaseArrSize)
						wo_ FAILED_AND_REMAINING_SET("")  //AK: 2008-04-29
					End if 
					
				End if 
			End if 
		End if 
	End for 
	_tbl WRITE_STATE(wos_kTbl; kPrevious)
End if 
