// plugin/vue-renderer/render-compile.js
// idea taken from: https://lachlan-miller.me/articles/vue-3-pdf-customer-renderer

let startTime = performance.now()

import fs from 'fs'
import { provide, defineComponent, compile, createRenderer } from 'vue' // './lib.js' // 'vue'
import { newDocument } from './element.js'
import { createNodeOps } from './nodeOps.js'
import { compileVueFile } from './compileVueFile.js'
import { newState } from '../component/nc-state.js'

let newComponentPath = '../component/'
const elementArr = JSON.parse(fs.readFileSync('./element-arr.json', 'utf8')).element
const compiledComponent = []
const comp = {}

let runStartTime = performance.now()
let srcPath = '../../../../nc-designer/src/components/'
elementArr.forEach(fileName => {
	compiledComponent.push(compileVueFile(srcPath, fileName, newComponentPath))
})
Promise.all(compiledComponent).then(ret => {
	ret.forEach(item => {
		comp[item.default.name] = item.default
	})
	run(comp)
})

function run(comp) {
	const stateRec = JSON.parse(fs.readFileSync('./state.json', 'utf8'))
	const state = newState('nc-render', stateRec)
	state.rec.printing = true
	let html = fs.readFileSync('./page.html', 'utf8')
	html = html.replaceAll('v-show=', 'v-if=')

	const App = defineComponent({
		name: 'NcRender',
		// components: comp, // create later by app.component(), components must be in app, here is not enugh
		setup() {
			provide('state', state)
			// return Object.assign({ style: appStyle }, toRefs(state)) // this is old-browser compatible version of '...state'
			return { ...state, state } // ...toRefs(state) if state is reactive
		},
		render: compile(`${html}`)
	})

	function createApp(...args) {
		// Modelled after https://github.com/vuejs/vue-next/blob/master/packages/runtime-dom/src/index.ts#L61
		const nodeMap = []
		const nodeOps = createNodeOps(nodeMap) // createNodeOps generates nodeMap
		const renderer = createRenderer(nodeOps)
		const app = renderer.createApp(...args) // vue call
		const { mount } = app

		app.mount = doc => {
			const proxy = mount(doc)
			doc.nodeMap = nodeMap
			return proxy
		}
		return app
	}
	const app = createApp(App)
	for (let key in comp) {
		app.component(key, comp[key])
	}
	const doc = newDocument()
	app.mount(doc) // this creates doc.nodeMap
	doc.nodeMap.shift() // The shift() method removes the first item of an array, we don't need first root
	delete doc.nodeMap[0].parent
	// console.log('\nnodeMap raw', doc.nodeMap)

	const nodeMap = doc.nodeMap.map(item => {
		const ret = {}
		for (const key in item) {
			if (!key.startsWith('_') && key !== 'nodeMap') {
				ret[key] = item[key]
			}
		}
		if (item.__vnode && item.__vnode.props) {
			const item2 = item.__vnode.props
			ret.props = {}
			for (const key2 in item2) {
				if (item2[key2] != null && typeof item2[key2] !== 'function') {
					ret.props[key2] = item2[key2]
				}
			}
		}
		return ret
	})
	runStartTime = performance.now() - runStartTime
	// console.log('\nnodeMap', nodeMap)
	let data = JSON.stringify(nodeMap, null, 2)
	fs.writeFileSync('./page.json', data)
	// renderToPDF(doc.nodeMap)
	startTime = performance.now() - startTime

	const msg =
		`%c* web page json create time: ` +
		(runStartTime / 1000).toFixed(4) +
		` seconds, total time: ` +
		(startTime / 1000).toFixed(4) +
		` seconds •••\n`
	console.debug(msg, 'font-weight: bold; font-style: italic;')
}
