//%attributes = {}
//******************************************************************************
//Method: SDA_CheckResDelete
//Written by  Cyril Harnisch on 2/5/99
//
//Purpose: Confirm delete and do it
//
//$1 - pointer -previous resource value holder
//$2 - pointer -resource value display variable
//$3 - time-document reference
//$4 - pointer-to resource ID array
//$5 - pointer-constants blob
//$6 - pointer-resource strings array
//$7 - string 4-resource type
//$8 - Boolean-save confirmation presentation flag; optional, default=true
//
//Copyright 1999 Syncor Systems, Inc.
//******************************************************************************
C_POINTER:C301($1; $2; $4; $pPrevResourceValue; $pResourceValue; $pResourceID_Array)
C_TIME:C306($3; $hDocReference)
C_POINTER:C301($5; $6; $pConstantsBlob; $pResourceStringAry)
_O_C_STRING:C293(4; $7; $s4ResourceType)
C_BOOLEAN:C305($8; $bDeleteConfirmationFlag)
C_LONGINT:C283($lResourceSelectedRow)
C_TEXT:C284($tMessage)

$pPrevResourceValue:=$1
$pResourceValue:=$2
$hDocReference:=$3
$pResourceID_Array:=$4
$pConstantsBlob:=$5
$pResourceStringAry:=$6
$s4ResourceType:=$7

If (Count parameters:C259>7)  //if at least 8 parameters
	$bDeleteConfirmationFlag:=$8
	
Else   //less than 8 parameters
	$bDeleteConfirmationFlag:=True:C214
End if   //If (Count parameters>7)  `if at least 8 parameters

$lResourceSelectedRow:=$pResourceStringAry->

If ($lResourceSelectedRow=0)  //if no resource is selected
	BEEP:C151
	_info_ ALERT("You must first select a resource to delete.")
	
Else   //resource was selected
	
	If ($bDeleteConfirmationFlag)  //if we do a confirmation  
		$tMessage:="Are you certain you wish to delete "+$pResourceValue->+"?"
		_info_ CONFIRM_SET_OK($tMessage)
		
	Else   //don't confirm
		OK:=1  //Make sure we delete    
	End if   //  If ($bDeleteConfirmationFlag)  `if we do a confirmation  
	
	If (OK=1)  //if user selected delete or no confirmation
		//#### delete the selected resource
		_O_DELETE RESOURCE:C501($s4ResourceType; $pResourceID_Array->{$lResourceSelectedRow}; 1)  //delete the resource
		
		If (OK=1)  //if the resource was deleted
			DELETE FROM ARRAY:C228($pResourceStringAry->; $lResourceSelectedRow; 1)  //Delete the currently selected resource name
			DELETE FROM ARRAY:C228($pResourceID_Array->; $lResourceSelectedRow; 1)  //Delete the currently selected resource ID
			$pPrevResourceValue->:=""  //update the resource variables to be empty
			$pResourceValue->:=""
			$pResourceStringAry->:=0  //update the resource array to have no selection
			OBJECT SET TITLE:C194(lbDone; "Cancel")
			
		Else   //the resource was not deleted
			BEEP:C151
			_info_ ALERT("Could not delete the resource.")
		End if 
		
	Else   //user chose not to delete
	End if   //  If (OK=1)  `if user selected delete or no confirmation
	
End if   //If ($pResourceStringAry->=0)  `if no resource is selected
