//%attributes = {}
//******************************************************************************
//Method: SDA_CheckResStrChangeSave
//Written by  Cyril Harnisch on 2/5/99
//
//Purpose: Check if the displayed resource string was changed and offer to save
// it if it was.
//
//$1 - pointer -previous resource value holder
//$2 - pointer -resource value display variable
//$3 - time-document reference
//$4 - longint-4DK# ID number
//$5 - pointer-constants blob
//$6 - pointer-resource string array
//$7 - string 4-resource type
//$8 - Boolean-save confirmation presentation flag; optional, default=true
//
//Copyright 1999 Syncor Systems, Inc.
//******************************************************************************
C_POINTER:C301($1; $2; $pPrevResourceValue; $pResourceValue)
C_TIME:C306($3; $hDocReference)
C_LONGINT:C283($4; $l4DK_ID)
C_LONGINT:C283($lResPositionInAry)
C_POINTER:C301($5; $6; $pConstantsBlob; $pResourceAry)
_O_C_STRING:C293(4; $7; $s4ResourceType)
C_BOOLEAN:C305($8; $bSaveConfirmationFlag)
C_TEXT:C284($tMessage)

$pPrevResourceValue:=$1
$pResourceValue:=$2
$hDocReference:=$3
$l4DK_ID:=$4
$pConstantsBlob:=$5
$pResourceAry:=$6
$s4ResourceType:=$7

If (Count parameters:C259>7)  //if at least 8 parameters
	$bSaveConfirmationFlag:=$8
	
Else   //less than 8 parameters
	$bSaveConfirmationFlag:=True:C214
End if   //If (Count parameters>6)  `if at least 7 parameters

If ($pPrevResourceValue->=$pResourceValue->)  //if resource was not changed
	
Else   //resource was changed
	
	If ($bSaveConfirmationFlag)  //if we do a confirmation  
		$tMessage:="Save updated resource "+$pResourceValue->+"?"
		_info_ CONFIRM_SET_OK($tMessage)
		
	Else   //don't confirm
		OK:=1  //Make sure we save    
	End if   //    If ($bSaveConfirmationFlag)  `if we do a confirmation  
	
	If (OK=1)  //if user selected update
		//#### update the changed resource
		$lResPositionInAry:=Find in array:C230($pResourceAry->; $pPrevResourceValue->)
		
		If ($lResPositionInAry=-1)  //if not found (should not happen)
			BEEP:C151
			
		Else   //eureka      
			$pResourceAry->{$lResPositionInAry}:=$pResourceValue->
			SDA_ResEdtrSaveResourceStr($l4DK_ID; ->$pConstantsBlob; $pResourceAry; $hDocReference; $s4ResourceType)
			$pPrevResourceValue->:=$pResourceValue->  //update the previous version holder   
		End if   //      If ($lResPositionInAry=-1)  `if not found (should not happen)
		
	Else   //user chose not to update
		$pResourceValue->:=$pPrevResourceValue->  //update display to previous version 
	End if   //    If (OK=1)  `if user selected update
	
End if   //If ($pPrevResourceValue->=$pResourceValue->)  `if resource was not changed
