//%attributes = {}
//******************************************************************************
//Method: Method: SDA_Comment
//
//Written by  Tod Gentille on 10/11/97
//
//Purpose: Intelligently comment out the highlighted lines in the design env. 
//wrap lines longer than 80 chars to multiple lines with a special continuation 
//character set in $CONTINUATION_CHAR
//If option key is held down do an intelligent Uncomment
//
//NOTE:This only works on what is highlighted. It does not comment
//or uncomment the current line if nothing is highlighted
//Copyright 1997 Syncor Systems, Inc.
//
//Modified 12/4/97 renamed atSourceLine to atSDA_SourceLine_L
//Modified teg 5/8/98 - now calls SDA_CheckForInitialCharacter
//and will auto uncomment if first nonblank selected line starts with `
//******************************************************************************

C_BOOLEAN:C305($bDoUncomment)

ARRAY TEXT:C222(<>atSDA_SourceLine_L; 0)  //Only using IP arrays so we can pass pointers to them
ARRAY TEXT:C222(<>atSDA_DestLine_L; 0)  //don't expect to use them after this method ends
//these same arrays may be used by other SDA routines that need utility text array
C_TEXT:C284(<>tSDA_Scrap)  //delcare it here again just to be safe in case user extracts this routine
//for some other use


If (Macintosh option down:C545)  //test now so user doesn't have to keep the option/alt key down
	$bDoUncomment:=True:C214
Else 
	$bDoUncomment:=False:C215
End if 

//Get whatever is highlighted
SDA_ClipboardOps(<>SDA_COPY; -><>tSDA_Scrap)

If (<>tSDA_Scrap="")  //don't do anything if the user didn't hilight something
	BEEP:C151
Else 
	
	//Put each line of the method into an array element
	SDA_util_Parse(<>tSDA_Scrap; -><>atSDA_SourceLine_L)
	If (Size of array:C274(<>atSDA_SourceLine_L)>0)  // if there is an element #1 of the selection
		//teg 5/8/98 add check to see if first line starts with ` 
		//if user isn't forcing us to do an uncomment
		If (Not:C34($bDoUncomment))
			$bDoUncomment:=SDA_util_CheckForInitialChar(-><>atSDA_SourceLine_L; <>SDA_COMMENT_CHAR)  //check for first line starting with comment char
		End if 
		
		
		If ($bDoUncomment)  //-------------------- Uncomment the lines
			<>tSDA_Scrap:=SDA_CommentRemove(-><>atSDA_SourceLine_L; -><>atSDA_DestLine_L)
		Else   //-------------------- comment the lines
			<>tSDA_Scrap:=SDA_CommentAdd(-><>atSDA_SourceLine_L; -><>atSDA_DestLine_L)
		End if   //-------------------- Check for Comment vs Uncomment
		
		//Either comment or uncomment paste our text var into the method editor  
		SDA_ClipboardOps(<>SDA_PASTE; -><>tSDA_Scrap)
	End if   //checking for the array of text lines being >0
End if   //checking for something in <>tScrap

//Clean up memory
<>tSDA_Scrap:=""
ARRAY TEXT:C222(<>atSDA_DestLine_L; 0)
ARRAY TEXT:C222(<>atSDA_SourceLine_L; 0)
//
