//%attributes = {}
//******************************************************************************
//Method: SDA_ExportOps
//
//Written by  Tod Gentille on 10/14/97
//
//Purpose: Handle the various export options
//
//Copyright 1997 Syncor Systems, Inc.
//
//Modified by: Cyril Harnisch, Syncor Systems, Inc., 3/3/99
//Reason: Added comments; moved instantiation of $tChoice to within conditional
//******************************************************************************
C_POINTER:C301($1; $pPopupMenu)
C_LONGINT:C283($iSelItem)
C_TEXT:C284($tChoice)

$pPopupMenu:=$1

$iSelItem:=$pPopupMenu->  //Find out which item was selected in the popup

If ($iSelItem>0)  //if an item selected in drop down
	$tChoice:=$pPopupMenu->{$iSelItem}  //Get the selected item
	
	Case of   //case of selection item of drop down
			
		: ($tChoice="Export Frontmost Window")
			<>lSDA_DesignPID:=SDA_util_SetDesignProcessNum(<>lSDA_DesignPID)  //Make sure the Design process ID is set
			SDA_ExportOne(True:C214)
			
		: ($tChoice="Export All Open Windows")
			
			If (<>bSDA_FilepackIsHere)
				<>lSDA_DesignPID:=SDA_util_SetDesignProcessNum(<>lSDA_DesignPID)  //Make sure the Design process ID is set
				SDA_ExportMany
				
			Else 
				SDA_util_BugAlert(<>SDA_REQUIRES_FILEPACK; "Method: SDA_ExportOps")
			End if   //      If (<>bSDA_FilepackIsHere)
			
		: (SDA_ExportOps_y($tChoice))  //Your added operations should be put in this method
			
		Else   //no recognized drop down item
			
			SDA_util_BugAlert(<>SDA_UNEXPECTED_PARAM; " Method: SDA_ExportOps "; $tChoice)
	End case   //  Case of   `case of selection item of drop down
	
End if   //If ($iSelItem>0)  `if an item selected in drop down
//
