//%attributes = {}
//******************************************************************************
//Method: SDA_ExtractComments
//Written by  Tod Gentille on 8/12/1998
//
//Purpose: Get the comments out the source code and write to a text file
//because 4D tends to slow down after opening a lot of methods this method
//prompts for a letter and opens all methods that start with that letter
//
//Copyright 1998 Syncor Systems, Inc.
//
//Modified by: Cyril Harnisch, Syncor Systems, Inc., 3/3/99
//Reason: Cleaned up code; changed prompt and code to use leading
// characters instead of 1 character to decide which methods to
// extract from.
//******************************************************************************
C_LONGINT:C283($lFound)
C_LONGINT:C283($i)
C_TEXT:C284($CR; $tFirstChar; $tCurrentFirstChar; $tWinTitle)
C_TEXT:C284($tMethod)  //store whatever thelocal version of 4D calls a "Method"
C_TIME:C306($hDocRefNum)

$CR:=Char:C90(Carriage return:K15:38)  //+Char(Line feed)
$tMethod:=Get indexed string:C510(77; 6)  //Get the 4D resource which holds the name of a method in this
// version of 4D (Japanese, German, etc. ACI may change where
// this is stored in future versions

ARRAY TEXT:C222(<>atSDA_SourceLine_L; 0)

$tFirstChar:=_str_ ToUpper(_info_ Request(<>SDA_OPEN_PROMPT))

If (OK=1)  //if user accepted extract leading string prompt
	$tCurrentFirstChar:=$tFirstChar
	$tWinTitle:="Nothing"
	$hDocRefNum:=Create document:C266("Comment_"+$tFirstChar)
	
	If (OK=1)  //if document successfully created
		SDA_util_GotoExplorerMethodTab
		SDA_util_PostKey(Character code:C91($tFirstChar); 0; False:C215)
		SDA_util_OpenExplorerMethod
		$tWinTitle:=SDA_util_GetWinTitleStripped
		$tFirstChar:=Substring:C12($tWinTitle; 1; Length:C16($tCurrentFirstChar))  //copy only the same number of characters
		// as the user input
		
		While ($tFirstChar=$tCurrentFirstChar)  //while method matches leading characters
			SEND PACKET:C103($hDocRefNum; $tMethod+" "+$tWinTitle+$CR)
			ARRAY TEXT:C222(<>atSDA_SourceLine_L; 0)
			
			If (SDA_util_PostSelectAll)  //if select all was successful
				SDA_ClipboardOps(<>SDA_COPY; -><>tSDA_Scrap)
				SDA_util_PostKey(Down arrow key:K12:19; 0; False:C215)  //unhighlight
				SDA_util_Parse(<>tSDA_Scrap; -><>atSDA_SourceLine_L)
				
				For ($i; 1; Size of array:C274(<>atSDA_SourceLine_L))  //for each line of method
					$lFound:=Position:C15(<>SDA_COMMENT_CHAR; <>atSDA_SourceLine_L{$i})  //check for  line containing comment char    
					
					If ($lFound#0)  //if comment character found on line
						SEND PACKET:C103($hDocRefNum; Substring:C12(<>atSDA_SourceLine_L{$i}; $lFound))
					End if   //          If ($lFound # 0)  `if comment character found on line
					
				End for   //        For ($i;1;Size of array(<>atSDA_SourceLine_L))  `for each line of method
				
				SEND PACKET:C103($hDocRefNum; $CR)
			End if   //      If (SDA_util_PostSelectAll )  `if select all was successful
			
			SDA_util_PostKey(<>SDA_ASCII_CLOSE_WINDOW_KEY; Command key mask:K16:1)
			SDA_util_OpenNextExplorerMethod
			$tWinTitle:=SDA_util_GetWinTitleStripped
			$tFirstChar:=Substring:C12($tWinTitle; 1; Length:C16($tCurrentFirstChar))  //copy only the same number of characters
			// as the user input
		End while   //    While ($tFirstChar=$tCurrentFirstChar)  `while method matches leading charac
		
		SDA_util_PostKey(<>SDA_ASCII_CLOSE_WINDOW_KEY; Command key mask:K16:1)  //close last method window opened
		CLOSE DOCUMENT:C267($hDocRefNum)
		
	Else   //document not successfully created
	End if   //  If (OK=1)  `if document successfully created
	
	BEEP:C151  //wake the user up
	BEEP:C151
	
Else   //user didn't supply an initial letter
End if   //If (OK=1)  `if user accepted extract leading string prompt
