//%attributes = {}
//******************************************************************************
//Method: SDA_FieldVerboseInfo(tableNum;FieldNum;bUseLongNames)
//
//Written by  Tod Gentille on 12/2/97
//
//Purpose: Return a text description of the type of field and whether it is indexe
//
//$1 - longint -number of the table 
//$2 - longint number of the field
//$3 - boolean if true return normal long names
//$0- text the additional field information 

//Copyright 1997 Syncor Systems, Inc.
//******************************************************************************
C_LONGINT:C283($1; $2)
C_BOOLEAN:C305($3)
C_LONGINT:C283($iFieldType; $iFieldLength; $lNumChars)
C_BOOLEAN:C305($bIsIndexed)

If ($3)
	$lNumChars:=80
Else 
	$lNumChars:=1
End if 

C_BOOLEAN:C305($bIsIndexed)

GET FIELD PROPERTIES:C258($1; $2; $iFieldType; $iFieldLength; $bIsIndexed)


Case of 
	: ($iFieldType=Is alpha field:K8:1)
		$0:=Substring:C12("Alpha"; 1; $lNumChars)+String:C10($iFieldLength; "00")
		
	: ($iFieldType=Is text:K8:3)
		$0:=Substring:C12("Text"; 1; $lNumChars)
		
	: ($iFieldType=Is real:K8:4)
		$0:=Substring:C12("Real"; 1; $lNumChars)
		
	: ($iFieldType=Is integer:K8:5)
		$0:=Substring:C12("Integer"; 1; $lNumChars)
		
	: ($iFieldType=Is longint:K8:6)
		$0:=Substring:C12("Long Integer"; 1; $lNumChars)
		
	: ($iFieldType=Is date:K8:7)
		$0:=Substring:C12("Date"; 1; $lNumChars)
		
	: ($iFieldType=Is time:K8:8)
		$0:=Substring:C12("Time"; 1; $lNumChars)
		
	: ($iFieldType=Is boolean:K8:9)
		$0:=Substring:C12("Boolean"; 1; $lNumChars)
		
	: ($iFieldType=Is picture:K8:10)
		$0:=Substring:C12("Picture"; 1; $lNumChars)
		
	: ($iFieldType=Is subtable:K8:11)
		$0:=Substring:C12("Subtable"; 1; $lNumChars)
		
	: ($iFieldType=Is BLOB:K8:12)
		$0:=Substring:C12("Blob"; 1; $lNumChars)
		
End case 

If ($bIsIndexed)
	$0:=$0+Substring:C12("*Indexed"; 1; $lNumChars)
End if 
