//%attributes = {}
//******************************************************************************
//Method: SDA_OnEventHandler
//
//Written by  Tod Gentille on 12/1/97
//
//Purpose: Trap the command keys intended for the SDA palette and paste them there
//
//NOTE: To avoid conflicts with existing shortcut keys the CMD-OPT (CTRL on
// Windows)
//combination triggers all the shortcuts. That is what is trapped, it is not the 
//same as the key shortcut set for the  object on the palette form. We can trap
//one thing and post another to the palette and we do. This was done because
//posting certain option keys didn't work. Some did some didn't so instead all the
//objects on the palette have straight CMD-key equivalents 
//For example to paste the method name you hit CMD-OPT-M but this routine justs
//posts a CMD-M to the palette. If you hit just CMD-M you get the normal 4D new 
//method. Strange but it works
//Copyright 1997 Syncor Systems, Inc.
//
//******************************************************************************


Case of 
		
		//on the mac using CMD-Option for the shortcut keys
	: ((Modifiers ?? Command key bit:K16:2) & (Modifiers ?? Option key bit:K16:8) & (Not:C34(<>SDA_IN_WINDOWS)))  //bitwise test the command /shift key
		
		Case of   //CMD - OPTION keys
				
			: (KeyCode=Character code:C91("?"))  //the option dash character- paste comment line of dashes
				POST KEY:C465(Character code:C91("-"); Command key mask:K16:1; <>lSDA_FloatWinProcessID)
				FILTER EVENT:C321
				
			: (KeyCode=Character code:C91("å"))  //the option A character
				POST KEY:C465(Character code:C91("a"); Command key mask:K16:1; <>lSDA_FloatWinProcessID)
				FILTER EVENT:C321
				
			: (KeyCode=Character code:C91("*"))  //the option B character- Paste Modified By
				POST KEY:C465(Character code:C91("b"); Command key mask:K16:1; <>lSDA_FloatWinProcessID)
				FILTER EVENT:C321
				
			: (KeyCode=Character code:C91("ç"))  //the option c character- copy clip 1
				POST KEY:C465(Character code:C91("c"); Command key mask:K16:1; <>lSDA_FloatWinProcessID)
				FILTER EVENT:C321
				
			: (KeyCode=Character code:C91("`"))  //the option comment character- Comment/Uncomment
				POST KEY:C465(Character code:C91("k"); Command key mask:K16:1; <>lSDA_FloatWinProcessID)
				FILTER EVENT:C321
				
			: (KeyCode=Character code:C91("©"))  //the option g character find the next highlighted text
				POST KEY:C465(Character code:C91("g"); Command key mask:K16:1; <>lSDA_FloatWinProcessID)
				FILTER EVENT:C321
				
			: (KeyCode=Character code:C91("*"))  //the option h character paste in header
				POST KEY:C465(Character code:C91("h"); Command key mask:K16:1; <>lSDA_FloatWinProcessID)
				FILTER EVENT:C321
			: (KeyCode=Character code:C91("h"))  //the option h character paste in header
				POST KEY:C465(Character code:C91("h"); Command key mask:K16:1; <>lSDA_FloatWinProcessID)
				FILTER EVENT:C321
				
			: (KeyCode=Character code:C91("÷"))  //the option / character get table field info
				POST KEY:C465(Character code:C91("/"); Command key mask:K16:1; <>lSDA_FloatWinProcessID)
				FILTER EVENT:C321
				
			: (KeyCode=Character code:C91("¬"))  //the optionl character - load window group
				POST KEY:C465(Character code:C91("l"); Command key mask:K16:1; <>lSDA_FloatWinProcessID)
				FILTER EVENT:C321
				
			: (KeyCode=Character code:C91("µ"))  //the option m character - Paste method name
				POST KEY:C465(Character code:C91("m"); Command key mask:K16:1; <>lSDA_FloatWinProcessID)
				FILTER EVENT:C321
				
			: (KeyCode=Character code:C91("*"))  //the option v character- paste clip 1
				POST KEY:C465(Character code:C91("v"); Command key mask:K16:1; <>lSDA_FloatWinProcessID)
				FILTER EVENT:C321
				
			: (KeyCode=Character code:C91("ß"))  //the option scharacter - save window group
				POST KEY:C465(Character code:C91("s"); Command key mask:K16:1; <>lSDA_FloatWinProcessID)
				FILTER EVENT:C321
				
			: (KeyCode=Character code:C91("?"))  //the option T character- Toggle palette
				POST KEY:C465(Character code:C91("t"); Command key mask:K16:1; <>lSDA_FloatWinProcessID)
				FILTER EVENT:C321
				
			Else   //it is not a key we want to trap
				
		End case 
		
		//on windows the option key is not working so just using the command key (the ctrl
		//key on windows, that means we disable any that conflict with 4D
		
	: ((Modifiers ?? Command key bit:K16:2) & <>SDA_IN_WINDOWS)  //bitwise test the command  key
		
		
		Case of 
				
			: (KeyCode=Character code:C91("?"))  //the option dash character- paste comment line of dashes
				POST KEY:C465(Character code:C91("?"); Control key mask:K16:9; <>lSDA_FloatWinProcessID)
				FILTER EVENT:C321
				
				// : (KeyCode=Ascii("å"))  `the option A character
				//    POST KEY(Ascii("a");Command key mask;<>lSDA_FloatWinProcessID)
				//    FILTER EVENT
				
			: (KeyCode=Character code:C91("b"))  //the  B character- Paste Modified By
				POST KEY:C465(Character code:C91("b"); Command key mask:K16:1; <>lSDA_FloatWinProcessID)
				FILTER EVENT:C321
				
				//  : (KeyCode=Ascii("ç"))  `copy clip 1
				//    POST KEY(Ascii("c");Command key mask;<>lSDA_FloatWinProcessID)
				//    FILTER EVENT
				
			: (KeyCode=Character code:C91("`"))  //the  comment character- Comment/Uncomment
				POST KEY:C465(Character code:C91("k"); Command key mask:K16:1; <>lSDA_FloatWinProcessID)
				FILTER EVENT:C321
				
				// : (KeyCode=Ascii("g"))  `the  g character find the next highlighted text
				//    POST KEY(Ascii("g");Command key mask;<>lSDA_FloatWinProcessID)
				//    FILTER EVENT
				//  
			: (KeyCode=Character code:C91("h"))  //the  h character paste in header
				POST KEY:C465(Character code:C91("h"); Command key mask:K16:1; <>lSDA_FloatWinProcessID)
				FILTER EVENT:C321
				
			: (KeyCode=Character code:C91("/"))  //the  / character get table field info
				POST KEY:C465(Character code:C91("/"); Command key mask:K16:1; <>lSDA_FloatWinProcessID)
				FILTER EVENT:C321
				
				//: (KeyCode=Ascii("l"))  `the  character - load window group
				//    POST KEY(Ascii("l");Command key mask;<>lSDA_FloatWinProcessID)
				//    FILTER EVENT
				//change from m to 2 
			: (KeyCode=Character code:C91("2"))  //the  2 character - Paste method name
				POST KEY:C465(Character code:C91("m"); Command key mask:K16:1; <>lSDA_FloatWinProcessID)
				FILTER EVENT:C321
				
				//: (KeyCode=Ascii("v))  `the  v character- paste clip 1
				//    POST KEY(Ascii("v");Command key mask;<>lSDA_FloatWinProcessID)
				//    FILTER EVENT
				//  
				// : (KeyCode=Ascii("d"))  `the  scharacter - save window group
				//    POST KEY(Ascii("s");Command key mask;<>lSDA_FloatWinProcessID)
				//    FILTER EVENT
				//  
				//Really want to have a keyboard way to toggle the palette since 4D uses T just 
				//use the number 1(it is the first button on palette)
			: (KeyCode=Character code:C91("1"))  //the 1 character- Toggle palette
				POST KEY:C465(Character code:C91("t"); Command key mask:K16:1; <>lSDA_FloatWinProcessID)
				FILTER EVENT:C321
				
			Else   //it is not a key we want to trap
				
		End case 
		
	Else   // check for other modifier keys if desired
		
End case 
