//%attributes = {}
//******************************************************************************
//Method: SDA_PaletteResize
//Written by  Tod Gentille on 9/25/1998
//
//Purpose: Toggles the SDA toolbar from a vertical to horiz. (vice/versa) 
//by resizeing  the window to show the correct buttons - fast and cheap
//$1 optional the x starting position of the palette
//$2 optional the y starting position of the palette
//the parameters are passed in by the routine that opens the palette
//for the first time if it could retrieve the last stored position from disk

//Copyright 1999 Syncor Systems, Inc.
//Modified by: Cyril Harnisch, Syncor Systems, Inc., 2/5/99
//Reason: Changed number of buttons from 14 to 15 to support the new
// resource editor button
//******************************************************************************
C_LONGINT:C283($1; $2)
C_LONGINT:C283($lxStart; $lyStart)
C_LONGINT:C283($lBUTTON_WIDTH; $LBUTTON_HEIGHT; $lVERT_PAD; $lHORIZ_PAD)
C_LONGINT:C283($lNUM_BUTTONS)
C_LONGINT:C283($lxStart; $lxStop; $lyStart; $lyStop)
//the following are only needed if you want to use the SDA_ResizePalette routine
C_LONGINT:C283(<>lSDA_PaletteWinRef; <>lSDA_PaletteWidth; <>lSDA_PaletteHeight)

$lBUTTON_WIDTH:=37
$LBUTTON_HEIGHT:=22
$lVERT_PAD:=3
$lHORIZ_PAD:=3
$lNUM_BUTTONS:=15

If (Count parameters:C259=2)  //if 2 parameters passed
	$lxStart:=$1
	$lyStart:=$2
	
Else   //no parameters passed or more than 2 passed
	GET WINDOW RECT:C443($lxStart; $lyStart; $lxStop; $lyStop; <>lSDA_PaletteWinRef)
	//... I sure wish we could pass pointers to locals...  
	C_LONGINT:C283(<>SDA_lxStart_L; <>SDA_lyStart_L)
	<>SDA_lxStart_L:=$lxStart
	<>SDA_lyStart_L:=$lyStart
	SDA_PaletteWinAdjust(-><>SDA_lxStart_L; -><>SDA_lyStart_L)
	$lxStart:=<>SDA_lxStart_L
	$lyStart:=<>SDA_lyStart_L
End if 

//Now set up the coordinates of the toolbar for either the vertical or horizontal 
If (<>bSDA_HorizontalToolbar)  //if toolbar is horizontal
	$lyStop:=$LBUTTON_HEIGHT+$lVERT_PAD+$lyStart
	$lxStop:=($lNUM_BUTTONS*$lBUTTON_WIDTH)+$lxStart+$lHORIZ_PAD
	OBJECT SET VISIBLE:C603(*; "vert_@"; False:C215)
	OBJECT SET VISIBLE:C603(*; "Horiz_@"; True:C214)
	
Else   //vertical tool bar
	$lyStop:=$lyStart+($lNUM_BUTTONS*$LBUTTON_HEIGHT)+$lVERT_PAD
	$lxStop:=$lBUTTON_WIDTH+$lHORIZ_PAD+$lxStart
	OBJECT SET VISIBLE:C603(*; "Horiz_@"; False:C215)
	OBJECT SET VISIBLE:C603(*; "vert_@"; True:C214)
End if 

//-------------------------------------------------------------------------------
//Set up the IP vars needed by SDA_ResizePalette, open the window and show the 
//correct palette
<>lSDA_PaletteWidth:=$lxStop-$lxStart
<>lSDA_PaletteHeight:=$lyStop-$lyStart
SET WINDOW RECT:C444($lxStart; $lyStart; $lxStop; $lyStop; <>lSDA_PaletteWinRef)
