//%attributes = {}
//******************************************************************************
//Method: c_ResEd4DK_Read
//Written by  Tod Gentille on 4/11/98
//
//Purpose: Read in a 4DK# based on the passed resource ID and store the 
//values in the passed array. The constants will be first read into
//the passed BLOB before parsing into the array
//
//Parameters- see below
//
//Copyright 1998 Syncor Systems, Inc.
//
//******************************************************************************

C_LONGINT:C283($1; $l4DK_ID)  //the resource ID to read
C_POINTER:C301($2; $poKonstant)  //pointer to the blob
C_POINTER:C301($3; $patKonstants)  //pointer to text array to hold constants
C_TIME:C306($4; $hDocRef)  //resource document Reference
_O_C_STRING:C293(4; $5)  //the 4 character resource type to read
_O_C_STRING:C293(4; $s4ResourceType)
C_LONGINT:C283($lOffset; $i)
_O_C_INTEGER:C282($iNumKonstants)

$l4DK_ID:=$1
$poKonstant:=$2
$patKonstants:=$3
$hDocRef:=$4
$s4ResourceType:=$5

$lOffset:=0

GET RESOURCE:C508($s4ResourceType; $l4DK_ID; $poKonstant->; $hDocRef)
//The number of items in the constant is stored in the first integer
//so strip that off into a constant

If (<>SDA_IN_WINDOWS)  //if on Windows
	$iNumKonstants:=BLOB to integer:C549($poKonstant->; PC byte ordering:K22:3; $loffset)
	
Else   //on Mac
	$iNumKonstants:=BLOB to integer:C549($poKonstant->; Macintosh byte ordering:K22:2; $loffset)
End if   //If (<>SDA_IN_WINDOWS)  `if on Windows

ARRAY TEXT:C222($patKonstants->; $iNumKonstants)

For ($i; 1; $iNumKonstants)
	$patKonstants->{$i}:=BLOB to text:C555($poKonstant->; Mac Pascal string:K22:8; $loffset)
End for   //For ($i;1;$iNumKonstants)


