//%attributes = {}
//******************************************************************************
//Method: SDA_ResEdtrSaveResourceStr
// (4DK#ResourceID;pBlob;pArrayof4DKSTrings;.RSR Doc Ref)
//
//Written by  Tod Gentille on 4/11/98
//
//Purpose: Write out the 4DK# resource that was changed 
//
//Copyright 1998 Syncor Systems, Inc.
//
//******************************************************************************
C_LONGINT:C283($1; $l4DK_ID)  //the resource ID to read
C_POINTER:C301($2; $pKonstant)  //pointer to the blob
C_POINTER:C301($3; $paKonstantStrings)  //pointer to text array to hold constants
C_TIME:C306($4; $hDocRef)  //resource document Reference
_O_C_STRING:C293(4; $5)  //the 4-character resource type to read
_O_C_STRING:C293(4; $s4ResourceType)
C_BOOLEAN:C305($bStatus)
C_LONGINT:C283($lOffset; $i)
_O_C_INTEGER:C282($iNumKonstants)

$l4DK_ID:=$1
$pKonstant:=$2
$paKonstantStrings:=$3
$hDocRef:=$4
$s4ResourceType:=$5
$lOffset:=0

$iNumKonstants:=Size of array:C274($paKonstantStrings->)
//the first 4 bytes in the resource contain the number of items.

If (<>SDA_IN_WINDOWS)  //if Windows
	INTEGER TO BLOB:C548($iNumKonstants; $pKonstant->; PC byte ordering:K22:3; $lOffset)
	
Else   //Mac
	INTEGER TO BLOB:C548($iNumKonstants; $pKonstant->; Macintosh byte ordering:K22:2; $lOffset)
End if   //If (<>SDA_IN_WINDOWS)  `if Windows

//Write out each of the constants to the blob
For ($i; 1; $iNumKonstants)  //for each resource element
	TEXT TO BLOB:C554($paKonstantStrings->{$i}; $pKonstant->; Mac Pascal string:K22:8; $lOffset)
End for   //For ($i;1;$iNumKonstants)  `for each resource element

SET BLOB SIZE:C606($pKonstant->; $lOffset)
//Finally,  send the blob to the resource
$bStatus:=SDA_ResourceFileSet($s4ResourceType; $l4DK_ID; $pKonstant; $hDocRef)
