//%attributes = {}
//******************************************************************************
//Method: SDA_WindowGroupSave
//Written by  Tod Gentille on 9/28/1998
//
//Purpose: Save the current group of windows to a document so that the user can
//reload them whenever the urge strikes
//
//Copyright 1998 Syncor Systems, Inc.
//******************************************************************************
C_BOOLEAN:C305($1; $bUseDefaultFile)
C_BLOB:C604($xWindowNames)
ARRAY TEXT:C222(<>atWinTitle_L; 0)  //local in scope but we must pass a pointer to it
C_TIME:C306($hSDA_DocRef)

$bUseDefaultFile:=$1
//Populate the array of window names
SDA_util_GetOpenWindowNames(-><>atWinTitle_L)
//Now limit to just method windows

VARIABLE TO BLOB:C532(<>atWinTitle_L; $xWindowNames)

If ($bUseDefaultFile)  //If we are to use the default file
	$hSDA_DocRef:=Create document:C266(Get 4D folder:C485+"SDA_WindowGroup")
	
Else   //don't use the default file
	$hSDA_DocRef:=Create document:C266("")  //create a  document
End if 

If (OK=1)  //the doc was created and opened 
	CLOSE DOCUMENT:C267($hSDA_DocRef)  //blob to doc must have the document closed
	//and we use the document system var to write to it  
	BLOB TO DOCUMENT:C526(Document; $xWindowNames)
	
	If (OK#1)  //then an error occured
		SDA_util_BugAlert(<>SDA_GENERAL_ERROR; "Method: SDA_WindowGroupSave")
	End if 
	
End if 
