//%attributes = {}
//******************************************************************************
//Method: SDA_util_BugAlert
//Written by  Tod Gentille on 9/24/1998
//
//Purpose: Display an error message when something unexpected
//happens in SDA. Do not use ALERT directly in methods
//so this it is easier to localize the error message for int'l users
//
//
//$1 - longint - type of error
//$2 - text-method name of calling method
//$3 - text-based on $1 used to display additional information
//
//Copyright 1998 Syncor Systems, Inc.
//
//Modified by: Cyril Harnisch, Syncor Systems, Inc., 2/16/99
//Reason: Cleaned up code; replaced ${2} declaration with $2;$3
//******************************************************************************
C_LONGINT:C283($1; $lErrorType)
C_TEXT:C284($2; $3; $tCallingMethod; $tAdditionalInfo)  //all parameters must be text
C_TEXT:C284($tCallingMethod)

$lErrorType:=$1
$tCallingMethod:=$2

Case of 
		
	: ($lErrorType=<>SDA_UNEXPECTED_PARAM)
		$tAdditionalInfo:=$3
		_info_ ALERT("Method:"+$tCallingMethod+" unexpected parameter of"+$tAdditionalInfo)
		
	: ($lErrorType=<>SDA_METHOD_COPY_ERROR)
		_info_ ALERT("Method:"+$tCallingMethod+" Problem copying text of method.")
		
	: ($lErrorType=<>SDA_STRING_NOT_FOUND)
		$tAdditionalInfo:=$3
		_info_ ALERT("Method:"+$tCallingMethod+" String '"+$tAdditionalInfo+"' not found.")
		
	: ($lErrorType=<>SDA_REQUIRES_FILEPACK)
		_info_ ALERT("Method:"+$tCallingMethod+" This features requires FilePack")
		
	: ($lErrorType=<>SDA_GENERAL_ERROR)
		_info_ ALERT("Method:"+$tCallingMethod+" Detected an error condition. ")
		
End case 
