//%attributes = {}
//******************************************************************************
//Method: SDA_util_CloseIfNewWindow
//Written by  Tod Gentille on 9/28/1998
//
//Purpose: Close the current window if it is not in the passed array of 
//window references. This allows SDA to get an array of all open window
//references then open other windows and only close them 
//if they weren't open to begin with. Routines like SDA_SimilarOpen
//and SDA_Replane_N_Methods need to do this
//
//$1 - pointer to array of window references
//
//Copyright 1998 Syncor Systems, Inc.
//******************************************************************************
C_POINTER:C301($1; $palWindowRefs)
C_LONGINT:C283($lWinFound; $lWinRef)
C_BOOLEAN:C305($0)

$palWindowRefs:=$1

$0:=True:C214
$lWinRef:=Frontmost window:C447
$lWinFound:=Find in array:C230($palWindowRefs->; $lWinRef)

If ($lWinFound=-1)  //if the window was not orig. open go ahead and close it
	$0:=SDA_util_CloseWindowWait
End if 
