//%attributes = {}
//******************************************************************************
//Method: SDA_util_FindInArray(arrayToSearch,ValueToLookFor,FoundElement)->status
//Written by  Tod Gentille on 9/25/1998
//
//Purpose: General purpose core routine that will search for a value in an array
//and put up an error message if not found and return false. Otherwise it returns
//true. The found element (or -1) is set in the passed parameter
//uses pointer for item 2 so that multiple types of arrays can be searched
//
//$1 - pointer to array to search
//$2 - ptr to value to find in array
//$3 - pointer to longint to hold found element
//$0 - boolean return true if item found
//
//Copyright 1998 Syncor Systems, Inc.
//
//******************************************************************************
C_POINTER:C301($1; $pArrayToSearch)
C_POINTER:C301($2; $pValueToFIndInArray)  //make it a pointer so any type of array can be searched
C_POINTER:C301($3; $plFoundElement)
C_BOOLEAN:C305($0)

C_TEXT:C284($tSearchValue)

$pArrayToSearch:=$1
$pValueToFIndInArray:=$2
$plFoundElement:=$3

$0:=True:C214
$plFoundElement->:=Find in array:C230($pArrayToSearch->; $pValueToFIndInArray->)

If ($plFoundElement->=-1)
	$tSearchValue:=SDA_util_ConvertToString($pValueToFIndInArray)
	SDA_util_BugAlert(<>SDA_ITEM_NOT_FOUND; "Method: SDA_util_FindInArray"; $tSearchValue)
	$0:=False:C215
End if 
