//%attributes = {}
//******************************************************************************
//Method: SDA_util_GetOpenWindowNames
//Written by  Tod Gentille on 9/28/1998
//
//Purpose: Get a list of all the open method window names and put them in the 
//passed array. 
//
//$1 - pointer to array to hold the list of window names 
//
//Copyright 1998 Syncor Systems, Inc.
//******************************************************************************
C_POINTER:C301($1; $patWindowTitle)
C_LONGINT:C283($lSize; $i)
C_TEXT:C284($tWinTitle)

$patWindowTitle:=$1

//Get all the open window references, create an array of window names
ARRAY LONGINT:C221($alWindowRef; 0)
WINDOW LIST:C442($alWindowRef)

$lSize:=Size of array:C274($alWindowRef)
ARRAY TEXT:C222($patWindowTitle->; $lSize)

For ($i; 1; $lSize)  //for each window
	
	If (SDA_util_IsProjectMethod($alWindowRef{$i}))  //if this is a project method window
		$tWinTitle:=Get window title:C450($alWindowRef{$i})
		$patWindowTitle->{$i}:=$tWinTitle
		
	Else   //not a project method window
	End if   //  If (SDA_util_IsProjectMethod ($alWindowRef{$i}))  `if this is a project method
	
End for   //For ($i;1;$lSize)  `for each window

//if there were any non method windows they will have no name entry
For ($i; $lSize; 1; -1)  //for each window, loop backwards
	
	If ($patWindowTitle->{$i}="")  //if window name is blank
		DELETE FROM ARRAY:C228($patWindowTitle->; $i; 1)  //delete it from array
	End if   //  If ($patWindowTitle->{$i}="")  `if window name is blank
	
End for   //For ($i;$lSize;1;-1)  `for each window, loop backwards
